/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseFunction;
import net.java.ao.DelegateConnection;
import net.java.ao.DelegateConnectionHandler;
import net.java.ao.DisposableDataSource;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLActionType;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.ddl.DDLValue;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Logger sqlLogger = LoggerFactory.getLogger((String)"net.java.ao.sql");
    private final Set<SqlListener> sqlListeners;
    private final DisposableDataSource dataSource;
    private final Map<Thread, Connection> connections;
    private final ReadWriteLock connectionsLock = new ReentrantReadWriteLock();
    private String quote;

    protected DatabaseProvider(DisposableDataSource dataSource) {
        this.dataSource = (DisposableDataSource)Preconditions.checkNotNull((Object)dataSource);
        this.connections = new HashMap<Thread, Connection>();
        this.sqlListeners = new CopyOnWriteArraySet<SqlListener>();
        this.sqlListeners.add(new LoggingSqlListener(this.sqlLogger));
    }

    private synchronized void loadQuoteString() {
        if (this.quote != null) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            if (conn == null) {
                throw new IllegalStateException("Could not get connection to load quote String");
            }
            this.quote = conn.getMetaData().getIdentifierQuoteString().trim();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to query the database", e);
        }
        finally {
            Common.closeQuietly(conn);
        }
    }

    protected String renderAutoIncrement() {
        return "AUTO_INCREMENT";
    }

    public final String[] renderAction(DDLAction action) {
        ArrayList<String> back = new ArrayList<String>();
        switch (action.getActionType()) {
            case CREATE: {
                back.add(this.renderTable(action.getTable()));
                back.addAll(Arrays.asList(this.renderFunctions(action.getTable())));
                back.addAll(Arrays.asList(this.renderSequences(action.getTable())));
                back.addAll(Arrays.asList(this.renderTriggers(action.getTable())));
                for (DDLIndex index : action.getTable().getIndexes()) {
                    DDLAction newAction = new DDLAction(DDLActionType.CREATE_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(newAction)));
                }
                break;
            }
            case DROP: {
                for (DDLIndex index : action.getTable().getIndexes()) {
                    DDLAction newAction = new DDLAction(DDLActionType.DROP_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(newAction)));
                }
                back.addAll(Arrays.asList(this.renderDropTriggers(action.getTable())));
                back.addAll(Arrays.asList(this.renderDropSequences(action.getTable())));
                back.addAll(Arrays.asList(this.renderDropFunctions(action.getTable())));
                back.add(this.renderDropTable(action.getTable()));
                break;
            }
            case ALTER_ADD_COLUMN: {
                back.addAll(Arrays.asList(this.renderAlterTableAddColumn(action.getTable(), action.getField())));
                for (DDLIndex index : action.getTable().getIndexes()) {
                    if (!index.getField().equals(action.getField().getName())) continue;
                    DDLAction newAction = new DDLAction(DDLActionType.CREATE_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(newAction)));
                }
                break;
            }
            case ALTER_CHANGE_COLUMN: {
                back.addAll(Arrays.asList(this.renderAlterTableChangeColumn(action.getTable(), action.getOldField(), action.getField())));
                break;
            }
            case ALTER_DROP_COLUMN: {
                for (DDLIndex index : action.getTable().getIndexes()) {
                    if (!index.getField().equals(action.getField().getName())) continue;
                    DDLAction newAction = new DDLAction(DDLActionType.DROP_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(newAction)));
                }
                back.addAll(Arrays.asList(this.renderAlterTableDropColumn(action.getTable(), action.getField())));
                break;
            }
            case ALTER_ADD_KEY: {
                back.add(this.renderAlterTableAddKey(action.getKey()));
                break;
            }
            case ALTER_DROP_KEY: {
                back.add(this.renderAlterTableDropKey(action.getKey()));
                break;
            }
            case CREATE_INDEX: {
                back.add(this.renderCreateIndex(action.getIndex()));
                break;
            }
            case DROP_INDEX: {
                back.add(this.renderDropIndex(action.getIndex()));
                break;
            }
            case INSERT: {
                back.add(this.renderInsert(action.getTable(), action.getValues()));
            }
        }
        return back.toArray(new String[back.size()]);
    }

    public String renderQuery(Query query, TableNameConverter converter, boolean count) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.renderQuerySelect(query, converter, count));
        sql.append(this.renderQueryJoins(query, converter));
        sql.append(this.renderQueryWhere(query));
        sql.append(this.renderQueryGroupBy(query));
        sql.append(this.renderQueryOrderBy(query));
        sql.append(this.renderQueryLimit(query));
        return sql.toString();
    }

    public Object parseValue(int type, String value) {
        if (value == null || value.equals("") || value.equals("NULL")) {
            return null;
        }
        ArrayList<DatabaseFunction> posFuncs = new ArrayList<DatabaseFunction>();
        for (DatabaseFunction func : DatabaseFunction.values()) {
            if (!this.renderFunction(func).equalsIgnoreCase(value)) continue;
            posFuncs.add(func);
        }
        if (posFuncs.size() > 0) {
            return posFuncs.toArray(new DatabaseFunction[posFuncs.size()]);
        }
        try {
            switch (type) {
                case -5: {
                    return Long.parseLong(value);
                }
                case -7: {
                    return Byte.parseByte(value);
                }
                case 16: {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt(value);
                    }
                    catch (Throwable t) {
                        return Boolean.parseBoolean(value);
                    }
                    return intValue == 0;
                }
                case 1: {
                    value.charAt(0);
                    break;
                }
                case 91: {
                    try {
                        Calendar back = Calendar.getInstance();
                        back.setTime(new SimpleDateFormat(this.getDateFormat()).parse(value));
                        return back;
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case 3: {
                    return Double.parseDouble(value);
                }
                case 8: {
                    return Double.parseDouble(value);
                }
                case 6: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case 4: {
                    return Integer.parseInt(value);
                }
                case 2: {
                    return Integer.parseInt(value);
                }
                case 7: {
                    return Double.parseDouble(value);
                }
                case 5: {
                    return Short.parseShort(value);
                }
                case 93: {
                    try {
                        Calendar back = Calendar.getInstance();
                        back.setTime(new SimpleDateFormat(this.getDateFormat()).parse(value));
                        return back;
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case -6: {
                    return Short.parseShort(value);
                }
                case 12: {
                    return value.substring(1, value.length() - 2);
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return null;
    }

    public void setQueryStatementProperties(Statement stmt, Query query) throws SQLException {
    }

    public void setQueryResultSetProperties(ResultSet res, Query query) throws SQLException {
    }

    public ResultSet getTables(Connection conn) throws SQLException {
        return conn.getMetaData().getTables(null, null, "", new String[]{"TABLE"});
    }

    public ResultSet getSequences(Connection conn) throws SQLException {
        return conn.getMetaData().getTables(null, null, "", new String[]{"SEQUENCE"});
    }

    protected String renderQuerySelect(Query query, TableNameConverter converter, boolean count) {
        StringBuilder sql = new StringBuilder();
        String tableName = query.getTable();
        if (tableName == null) {
            tableName = converter.getName(query.getTableType());
        }
        switch (query.getType()) {
            case SELECT: {
                sql.append("SELECT ");
                if (query.isDistinct()) {
                    sql.append("DISTINCT ");
                }
                if (count) {
                    sql.append("COUNT(*)");
                } else {
                    StringBuilder fields = new StringBuilder();
                    for (String field : query.getFields()) {
                        fields.append(this.processID(field)).append(',');
                    }
                    if (query.getFields().length > 0) {
                        fields.setLength(fields.length() - 1);
                    }
                    sql.append((CharSequence)fields);
                }
                sql.append(" FROM ");
                sql.append(this.processID(tableName));
            }
        }
        return sql.toString();
    }

    protected String renderQueryJoins(Query query, TableNameConverter converter) {
        StringBuilder sql = new StringBuilder();
        if (query.getJoins().size() > 0) {
            for (Class<? extends RawEntity<?>> clazz : query.getJoins().keySet()) {
                sql.append(" JOIN ");
                sql.append(this.processID(converter.getName(clazz)));
                String on = query.getJoins().get(clazz);
                if (on == null) continue;
                sql.append(" ON ");
                sql.append(this.processID(on));
            }
        }
        return sql.toString();
    }

    protected String renderQueryWhere(Query query) {
        StringBuilder sql = new StringBuilder();
        String whereClause = query.getWhereClause();
        if (whereClause != null) {
            sql.append(" WHERE ");
            sql.append(this.processWhereClause(whereClause));
        }
        return sql.toString();
    }

    protected String renderQueryGroupBy(Query query) {
        StringBuilder sql = new StringBuilder();
        String groupClause = query.getGroupClause();
        if (groupClause != null) {
            sql.append(" GROUP BY ");
            sql.append(this.processGroupByClause(groupClause));
        }
        return sql.toString();
    }

    private String processGroupByClause(String groupBy) {
        return SqlUtils.GROUP_BY_CLAUSE.matcher(groupBy).replaceAll(this.processID("$1"));
    }

    protected String renderQueryOrderBy(Query query) {
        StringBuilder sql = new StringBuilder();
        String orderClause = query.getOrderClause();
        if (orderClause != null) {
            sql.append(" ORDER BY ");
            sql.append(this.processOrderClause(orderClause));
        }
        return sql.toString();
    }

    private String processOrderClause(String order) {
        return SqlUtils.ORDER_CLAUSE.matcher(order).replaceFirst(this.processID("$1"));
    }

    protected String renderQueryLimit(Query query) {
        int offset;
        StringBuilder sql = new StringBuilder();
        int limit = query.getLimit();
        if (limit >= 0) {
            sql.append(" LIMIT ");
            sql.append(limit);
        }
        if ((offset = query.getOffset()) > 0) {
            sql.append(" OFFSET ").append(offset);
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        this.connectionsLock.writeLock().lock();
        try {
            Connection conn = this.connections.get(Thread.currentThread());
            if (conn != null && !conn.isClosed()) {
                Connection connection = conn;
                return connection;
            }
            Connection connectionImpl = this.dataSource.getConnection();
            if (connectionImpl == null) {
                throw new SQLException("Unable to create connection");
            }
            conn = DelegateConnectionHandler.newInstance(connectionImpl);
            this.setPostConnectionProperties(conn);
            this.connections.put(Thread.currentThread(), conn);
            Connection connection = conn;
            return connection;
        }
        finally {
            this.connectionsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.connectionsLock.writeLock().lock();
        try {
            for (Connection conn : this.connections.values()) {
                if (conn instanceof DelegateConnection) {
                    ((DelegateConnection)conn).setCloseable(true);
                }
                conn.close();
            }
            this.dataSource.dispose();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.connectionsLock.writeLock().unlock();
        }
    }

    protected void setPostConnectionProperties(Connection conn) throws SQLException {
    }

    protected String renderConstraintsForTable(DDLTable table) {
        StringBuilder back = new StringBuilder();
        for (DDLForeignKey key : table.getForeignKeys()) {
            back.append("    ").append(this.renderForeignKey(key)).append(",\n");
        }
        return back.toString();
    }

    protected String renderForeignKey(DDLForeignKey key) {
        StringBuilder back = new StringBuilder();
        back.append("CONSTRAINT ").append(this.processID(key.getFKName()));
        back.append(" FOREIGN KEY (").append(this.processID(key.getField())).append(") REFERENCES ");
        back.append(this.processID(key.getTable())).append('(').append(this.processID(key.getForeignField())).append(")");
        return back.toString();
    }

    protected String convertTypeToString(DatabaseType<?> type) {
        return type.getDefaultName();
    }

    protected String renderTable(DDLTable table) {
        StringBuilder back = new StringBuilder("CREATE TABLE ");
        back.append(this.processID(table.getName()));
        back.append(" (\n");
        LinkedList<String> primaryKeys = new LinkedList<String>();
        StringBuilder append = new StringBuilder();
        for (DDLField field : table.getFields()) {
            back.append("    ").append(this.renderField(field)).append(",\n");
            if (!field.isPrimaryKey()) continue;
            primaryKeys.add(field.getName());
        }
        append.append(this.renderConstraintsForTable(table));
        back.append((CharSequence)append);
        if (primaryKeys.size() > 1) {
            throw new RuntimeException("Entities may only have one primary key");
        }
        if (primaryKeys.size() > 0) {
            back.append("    PRIMARY KEY(");
            back.append(this.processID((String)primaryKeys.get(0)));
            back.append(")\n");
        }
        back.append(")");
        String tailAppend = this.renderAppend();
        if (tailAppend != null) {
            back.append(' ');
            back.append(tailAppend);
        }
        return back.toString();
    }

    protected String renderInsert(DDLTable ddlTable, DDLValue[] ddlValues) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (DDLValue v : ddlValues) {
            columns.append(this.processID(v.getField().getName())).append(",");
            values.append(this.renderValue(v.getValue())).append(",");
        }
        columns.deleteCharAt(columns.length() - 1);
        values.deleteCharAt(values.length() - 1);
        return "INSERT INTO " + this.processID(ddlTable.getName()) + "(" + columns + ")" + " VALUES (" + values + ")";
    }

    protected String renderDropTable(DDLTable table) {
        return "DROP TABLE " + this.processID(table.getName());
    }

    protected String[] renderDropFunctions(DDLTable table) {
        return new String[0];
    }

    protected String[] renderDropTriggers(DDLTable table) {
        return new String[0];
    }

    protected String[] renderDropSequences(DDLTable table) {
        return new String[0];
    }

    protected String[] renderFunctions(DDLTable table) {
        ArrayList<String> back = new ArrayList<String>();
        for (DDLField field : table.getFields()) {
            String function = this.renderFunctionForField(table, field);
            if (function == null) continue;
            back.add(function);
        }
        return back.toArray(new String[back.size()]);
    }

    protected String[] renderTriggers(DDLTable table) {
        ArrayList<String> back = new ArrayList<String>();
        for (DDLField field : table.getFields()) {
            String trigger = this.renderTriggerForField(table, field);
            if (trigger == null) continue;
            back.add(trigger);
        }
        return back.toArray(new String[back.size()]);
    }

    protected String[] renderSequences(DDLTable table) {
        return new String[0];
    }

    protected String[] renderAlterTableAddColumn(DDLTable table, DDLField field) {
        String trigger;
        ArrayList<String> back = new ArrayList<String>();
        back.add("ALTER TABLE " + this.processID(table.getName()) + " ADD COLUMN " + this.renderField(field));
        String function = this.renderFunctionForField(table, field);
        if (function != null) {
            back.add(function);
        }
        if ((trigger = this.renderTriggerForField(table, field)) != null) {
            back.add(trigger);
        }
        return back.toArray(new String[back.size()]);
    }

    protected String[] renderAlterTableChangeColumn(DDLTable table, DDLField oldField, DDLField field) {
        String function;
        ArrayList<String> back = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        String trigger = this.getTriggerNameForField(table, oldField);
        if (trigger != null) {
            current.setLength(0);
            current.append("DROP TRIGGER ").append(this.processID(trigger));
            back.add(current.toString());
        }
        if ((function = this.getFunctionNameForField(table, oldField)) != null) {
            current.setLength(0);
            current.append("DROP FUNCTION ").append(this.processID(function));
            back.add(current.toString());
        }
        back.add(this.renderAlterTableChangeColumnStatement(table, oldField, field));
        String toRender = this.renderFunctionForField(table, field);
        if (toRender != null) {
            back.add(toRender);
        }
        if ((toRender = this.renderTriggerForField(table, field)) != null) {
            back.add(toRender);
        }
        return back.toArray(new String[back.size()]);
    }

    protected String renderAlterTableChangeColumnStatement(DDLTable table, DDLField oldField, DDLField field) {
        StringBuilder current = new StringBuilder();
        current.append("ALTER TABLE ").append(this.processID(table.getName())).append(" CHANGE COLUMN ");
        current.append(this.processID(oldField.getName())).append(' ');
        current.append(this.renderField(field));
        return current.toString();
    }

    protected String[] renderAlterTableDropColumn(DDLTable table, DDLField field) {
        String function;
        ArrayList<String> back = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        String trigger = this.getTriggerNameForField(table, field);
        if (trigger != null) {
            current.setLength(0);
            current.append("DROP TRIGGER ").append(this.processID(trigger));
            back.add(current.toString());
        }
        if ((function = this.getFunctionNameForField(table, field)) != null) {
            current.setLength(0);
            current.append("DROP FUNCTION ").append(this.processID(function));
            back.add(current.toString());
        }
        current.setLength(0);
        current.append("ALTER TABLE ").append(this.processID(table.getName())).append(" DROP COLUMN ").append(this.processID(field.getName()));
        back.add(current.toString());
        return back.toArray(new String[back.size()]);
    }

    protected String renderAlterTableAddKey(DDLForeignKey key) {
        StringBuilder back = new StringBuilder();
        back.append("ALTER TABLE ").append(this.processID(key.getDomesticTable())).append(" ADD ");
        back.append(this.renderForeignKey(key));
        return back.toString();
    }

    protected String renderAlterTableDropKey(DDLForeignKey key) {
        return "ALTER TABLE " + this.processID(key.getDomesticTable()) + " DROP FOREIGN KEY " + this.processID(key.getFKName());
    }

    protected String renderCreateIndex(DDLIndex index) {
        StringBuilder back = new StringBuilder();
        back.append("CREATE INDEX ").append(this.processID(index.getName()));
        back.append(" ON ").append(this.processID(index.getTable())).append('(').append(this.processID(index.getField())).append(')');
        return back.toString();
    }

    protected String renderDropIndex(DDLIndex index) {
        StringBuilder back = new StringBuilder();
        back.append("DROP INDEX ").append(this.processID(index.getName()));
        back.append(" ON ").append(this.processID(index.getTable()));
        return back.toString();
    }

    protected String renderAppend() {
        return null;
    }

    protected String renderField(DDLField field) {
        String renderUnique;
        StringBuilder back = new StringBuilder();
        back.append(this.processID(field.getName()));
        back.append(" ");
        back.append(this.renderFieldType(field));
        back.append(this.renderFieldPrecision(field));
        if (field.isAutoIncrement()) {
            String autoIncrementValue = this.renderAutoIncrement();
            if (!autoIncrementValue.trim().equals("")) {
                back.append(' ').append(autoIncrementValue);
            }
        } else if (field.getDefaultValue() != null) {
            back.append(" DEFAULT ");
            back.append(this.renderValue(field.getDefaultValue()));
        }
        if (field.isUnique() && !(renderUnique = this.renderUnique()).trim().equals("")) {
            back.append(' ').append(renderUnique);
        }
        if (field.isNotNull() || field.isUnique()) {
            back.append(" NOT NULL");
        }
        if (field.getOnUpdate() != null) {
            back.append(this.renderOnUpdate(field));
        }
        return back.toString();
    }

    protected String renderFieldPrecision(DDLField field) {
        StringBuilder back = new StringBuilder();
        if (this.considerPrecision(field) && field.getPrecision() > 0) {
            back.append('(');
            if (field.getScale() > 0) {
                back.append(field.getPrecision());
                back.append(',');
                back.append(field.getScale());
            } else {
                back.append(field.getPrecision());
            }
            back.append(')');
        }
        return back.toString();
    }

    protected String renderValue(Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Calendar) {
            return "'" + this.renderCalendar((Calendar)value) + "'";
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof DatabaseFunction) {
            return this.renderFunction((DatabaseFunction)((Object)value));
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return "'" + value.toString() + "'";
    }

    protected String renderCalendar(Calendar calendar) {
        return new SimpleDateFormat(this.getDateFormat()).format(calendar.getTime());
    }

    protected String renderUnique() {
        return "UNIQUE";
    }

    protected String getDateFormat() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String renderFieldType(DDLField field) {
        return this.convertTypeToString(field.getType());
    }

    protected String renderFunction(DatabaseFunction func) {
        switch (func) {
            case CURRENT_DATE: {
                return "CURRENT_DATE";
            }
            case CURRENT_TIMESTAMP: {
                return "CURRENT_TIMESTAMP";
            }
        }
        return null;
    }

    protected String renderOnUpdate(DDLField field) {
        StringBuilder back = new StringBuilder();
        back.append(" ON UPDATE ");
        back.append(this.renderValue(field.getOnUpdate()));
        return back.toString();
    }

    public Object handleBlob(ResultSet res, Class<?> type, String field) throws SQLException {
        Blob blob = res.getBlob(field);
        if (type.equals(InputStream.class)) {
            return blob.getBinaryStream();
        }
        if (type.equals(byte[].class)) {
            return blob.getBytes(1L, (int)blob.length());
        }
        return null;
    }

    protected boolean considerPrecision(DDLField field) {
        return true;
    }

    protected String getTriggerNameForField(DDLTable table, DDLField field) {
        return null;
    }

    protected String renderTriggerForField(DDLTable table, DDLField field) {
        return null;
    }

    protected String getFunctionNameForField(DDLTable table, DDLField field) {
        return null;
    }

    protected String renderFunctionForField(DDLTable table, DDLField field) {
        return null;
    }

    public <T> T insertReturningKey(EntityManager manager, Connection conn, Class<T> pkType, String pkField, boolean pkIdentity, String table, DBParam ... params) throws SQLException {
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.processID(table) + " (");
        for (DBParam param : params) {
            sql.append(this.processID(param.getField()));
            sql.append(',');
        }
        if (params.length > 0) {
            sql.setLength(sql.length() - 1);
        } else {
            sql.append(this.processID(pkField));
        }
        sql.append(") VALUES (");
        for (DBParam param : params) {
            sql.append("?,");
        }
        if (params.length > 0) {
            sql.setLength(sql.length() - 1);
        } else {
            sql.append("DEFAULT");
        }
        sql.append(")");
        return this.executeInsertReturningKey(manager, conn, pkType, pkField, sql.toString(), params);
    }

    protected <T> T executeInsertReturningKey(EntityManager manager, Connection conn, Class<T> pkType, String pkField, String sql, DBParam ... params) throws SQLException {
        Object back = null;
        PreparedStatement stmt = this.preparedStatement(conn, sql, 1);
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i].getValue();
            if (value instanceof RawEntity) {
                value = Common.getPrimaryKeyValue((RawEntity)value);
            }
            if (params[i].getField().equalsIgnoreCase(pkField)) {
                back = value;
            }
            if (value == null) {
                this.putNull(stmt, i + 1);
                continue;
            }
            DatabaseType<?> type = TypeManager.getInstance().getType(value.getClass());
            type.putToDatabase(manager, stmt, i + 1, value);
        }
        stmt.executeUpdate();
        if (back == null) {
            ResultSet res = stmt.getGeneratedKeys();
            if (res.next()) {
                back = TypeManager.getInstance().getType(pkType).pullFromDatabase(null, res, pkType, 1);
            }
            res.close();
        }
        stmt.close();
        return (T)back;
    }

    public void putNull(PreparedStatement stmt, int index) throws SQLException {
        stmt.setString(index, null);
    }

    public void putBoolean(PreparedStatement stmt, int index, boolean value) throws SQLException {
        stmt.setBoolean(index, value);
    }

    protected boolean isNumericType(int type) {
        switch (type) {
            case -5: {
                return true;
            }
            case -7: {
                return true;
            }
            case 3: {
                return true;
            }
            case 8: {
                return true;
            }
            case 6: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 7: {
                return true;
            }
            case 5: {
                return true;
            }
            case -6: {
                return true;
            }
        }
        return false;
    }

    public String processWhereClause(String where) {
        return SqlUtils.WHERE_CLAUSE.matcher(where).replaceAll(this.processID("$1"));
    }

    public final String processID(String id) {
        return this.quote(this.shorten(id));
    }

    public final String shorten(String id) {
        int maxIDLength = this.getMaxIDLength();
        if (id.length() > maxIDLength) {
            int tailLength = maxIDLength / 3;
            int hash = (int)((long)id.hashCode() % Math.round(Math.pow(10.0, tailLength)));
            hash = Math.abs(hash);
            id = id.substring(0, maxIDLength - tailLength - 1);
            id = id + hash;
        }
        return id;
    }

    public final String quote(String id) {
        if (this.shouldQuoteID(id)) {
            this.loadQuoteString();
            return this.quote + id + this.quote;
        }
        return id;
    }

    protected boolean shouldQuoteID(String id) {
        return this.getReservedWords().contains(id.toUpperCase());
    }

    protected int getMaxIDLength() {
        return Integer.MAX_VALUE;
    }

    protected abstract Set<String> getReservedWords();

    public boolean isCaseSensetive() {
        return true;
    }

    public void handleUpdateError(String sql, SQLException e) throws SQLException {
        this.sqlLogger.error("Exception executing SQL update <" + sql + ">", (Throwable)e);
        throw e;
    }

    public final PreparedStatement preparedStatement(Connection c, CharSequence sql) throws SQLException {
        String sqlString = ((Object)sql).toString();
        this.onSql(sqlString);
        return c.prepareStatement(sqlString);
    }

    public final PreparedStatement preparedStatement(Connection c, CharSequence sql, int autoGeneratedKeys) throws SQLException {
        String sqlString = ((Object)sql).toString();
        this.onSql(sqlString);
        return c.prepareStatement(sqlString, autoGeneratedKeys);
    }

    public final PreparedStatement preparedStatement(Connection c, CharSequence sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String sqlString = ((Object)sql).toString();
        this.onSql(sqlString);
        return c.prepareStatement(sqlString, resultSetType, resultSetConcurrency);
    }

    public final void executeUpdate(Statement stmt, CharSequence sql) throws SQLException {
        String sqlString = ((Object)sql).toString();
        try {
            this.onSql(sqlString);
            ((Statement)Preconditions.checkNotNull((Object)stmt)).executeUpdate(sqlString);
        }
        catch (SQLException e) {
            this.handleUpdateError(sqlString, e);
        }
    }

    public final void addSqlListener(SqlListener l) {
        this.sqlListeners.add(l);
    }

    public final void removeSqlListener(SqlListener l) {
        this.sqlListeners.remove(l);
    }

    protected final void onSql(String sql) {
        for (SqlListener sqlListener : this.sqlListeners) {
            sqlListener.onSql(sql);
        }
    }

    private static final class LoggingSqlListener
    implements SqlListener {
        private final Logger logger;

        public LoggingSqlListener(Logger logger) {
            this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        }

        @Override
        public void onSql(String sql) {
            this.logger.debug(sql);
        }
    }

    public static interface SqlListener {
        public void onSql(String var1);
    }
}

