/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.java.ao.DatabaseProvider;
import net.java.ao.Query;
import net.java.ao.SchemaConfiguration;
import net.java.ao.schema.helper.DatabaseMetaDataReader;
import net.java.ao.schema.helper.Field;
import net.java.ao.schema.helper.ForeignKey;
import net.java.ao.sql.AbstractCloseableResultSetMetaData;
import net.java.ao.sql.CloseableResultSetMetaData;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.TypeManager;

public class DatabaseMetaDataReaderImpl
implements DatabaseMetaDataReader {
    private final DatabaseProvider databaseProvider;
    private final SchemaConfiguration schemaConfiguration;

    public DatabaseMetaDataReaderImpl(DatabaseProvider databaseProvider, SchemaConfiguration schemaConfiguration) {
        this.databaseProvider = databaseProvider;
        this.schemaConfiguration = schemaConfiguration;
    }

    @Override
    public Iterable<String> getTableNames(DatabaseMetaData metaData) {
        LinkedList linkedList;
        ResultSet rs = null;
        try {
            rs = this.databaseProvider.getTables(metaData.getConnection());
            LinkedList tableNames = Lists.newLinkedList();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!this.schemaConfiguration.shouldManageTable(tableName, this.databaseProvider.isCaseSensetive())) continue;
                tableNames.add(tableName);
            }
            linkedList = tableNames;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(rs);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends Field> getFields(DatabaseMetaData databaseMetaData, String tableName) {
        TypeManager manager = TypeManager.getInstance();
        List<String> sequenceNames = this.getSequenceNames(databaseMetaData);
        HashMap fields = Maps.newHashMap();
        CloseableResultSetMetaData rsmd = null;
        try {
            rsmd = this.getResultSetMetaData(databaseMetaData, tableName);
            for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                String fieldName = rsmd.getColumnName(i);
                DatabaseType<?> databaseType = manager.getType(rsmd.getColumnType(i));
                int precision = this.getFieldPrecision(rsmd, i);
                int scale = this.getScale(rsmd, i);
                boolean autoIncrement = this.isAutoIncrement(rsmd, i, sequenceNames, tableName, fieldName);
                boolean notNull = this.isNotNull(rsmd, i);
                fields.put(fieldName, this.newField(fieldName, databaseType, precision, scale, autoIncrement, notNull));
            }
            ResultSet rs = null;
            try {
                rs = databaseMetaData.getColumns(null, null, tableName, null);
                while (rs.next()) {
                    FieldImpl current = (FieldImpl)fields.get(rs.getString("COLUMN_NAME"));
                    current.setDefaultValue(this.databaseProvider.parseValue(current.getDatabaseType().getType(), rs.getString("COLUMN_DEF")));
                    current.setNotNull(rs.getString("IS_NULLABLE").equals("NO"));
                }
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
            SqlUtils.closeQuietly(rs);
            try {
                rs = databaseMetaData.getPrimaryKeys(null, null, tableName);
                while (rs.next()) {
                    ((FieldImpl)fields.get(rs.getString("COLUMN_NAME"))).setPrimaryKey(true);
                }
            }
            finally {
                SqlUtils.closeQuietly(rs);
            }
            Collection collection = fields.values();
            return collection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rsmd != null) {
                rsmd.close();
            }
        }
    }

    private List<String> getSequenceNames(DatabaseMetaData metaData) {
        LinkedList linkedList;
        ResultSet rs = null;
        try {
            rs = this.databaseProvider.getSequences(metaData.getConnection());
            LinkedList sequenceNames = Lists.newLinkedList();
            while (rs.next()) {
                sequenceNames.add(this.databaseProvider.processID(rs.getString("TABLE_NAME")));
            }
            linkedList = sequenceNames;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(rs);
        return linkedList;
    }

    private boolean isAutoIncrement(ResultSetMetaData rsmd, int i, List<String> sequenceNames, String tableName, String fieldName) throws SQLException {
        boolean autoIncrement = rsmd.isAutoIncrement(i);
        if (!autoIncrement) {
            autoIncrement = this.isUsingSequence(sequenceNames, tableName, fieldName);
        }
        return autoIncrement;
    }

    private boolean isUsingSequence(List<String> sequenceNames, String tableName, String fieldName) {
        return sequenceNames.contains(this.databaseProvider.processID(tableName + '_' + fieldName + "_SEQ"));
    }

    private FieldImpl newField(String fieldName, DatabaseType<?> databaseType, int precision, int scale, boolean autoIncrement, boolean notNull) {
        return new FieldImpl(fieldName, databaseType, precision, scale, autoIncrement, notNull);
    }

    private boolean isNotNull(ResultSetMetaData resultSetMetaData, int fieldIndex) throws SQLException {
        return resultSetMetaData.isNullable(fieldIndex) == 0;
    }

    private int getScale(ResultSetMetaData rsmd, int fieldIndex) throws SQLException {
        int scale = rsmd.getScale(fieldIndex);
        return scale <= 0 ? -1 : scale;
    }

    private int getFieldPrecision(ResultSetMetaData resultSetMetaData, int fieldIndex) throws SQLException {
        int precision = resultSetMetaData.getPrecision(fieldIndex);
        if (precision == Integer.MAX_VALUE && 12 == resultSetMetaData.getColumnType(fieldIndex)) {
            precision = resultSetMetaData.getColumnDisplaySize(fieldIndex);
        }
        return precision <= 0 ? -1 : precision;
    }

    private CloseableResultSetMetaData getResultSetMetaData(DatabaseMetaData metaData, String tableName) throws SQLException {
        Query query = Query.select("*").from(tableName).limit(1);
        final PreparedStatement stmt = metaData.getConnection().prepareStatement(this.databaseProvider.renderQuery(query, null, false));
        this.databaseProvider.setQueryStatementProperties(stmt, query);
        final ResultSet rs = stmt.executeQuery();
        return new AbstractCloseableResultSetMetaData(rs.getMetaData()){

            @Override
            public void close() {
                SqlUtils.closeQuietly(rs);
                SqlUtils.closeQuietly(stmt);
            }
        };
    }

    public Iterable<ForeignKey> getForeignKeys(DatabaseMetaData metaData, String tableName) {
        LinkedList linkedList;
        ResultSet resultSet = null;
        try {
            LinkedList keys = Lists.newLinkedList();
            resultSet = this.getImportedKeys(metaData, tableName);
            while (resultSet.next()) {
                keys.add(this.newForeignKey(resultSet, tableName));
            }
            linkedList = keys;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(resultSet);
        return linkedList;
    }

    private ResultSet getImportedKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        return metaData.getImportedKeys(null, null, tableName);
    }

    private ForeignKey newForeignKey(ResultSet rs, String localTableName) throws SQLException {
        String localFieldName = rs.getString("FKCOLUMN_NAME");
        String foreignFieldName = rs.getString("PKCOLUMN_NAME");
        String foreignTableName = rs.getString("PKTABLE_NAME");
        return new ForeignKeyImpl(localTableName, localFieldName, foreignTableName, foreignFieldName);
    }

    private static final class ForeignKeyImpl
    implements ForeignKey {
        private final String localTableName;
        private final String localFieldName;
        private final String foreignTableName;
        private final String foreignFieldName;

        public ForeignKeyImpl(String localTableName, String localFieldName, String foreignTableName, String foreignFieldName) {
            this.localTableName = localTableName;
            this.localFieldName = localFieldName;
            this.foreignTableName = foreignTableName;
            this.foreignFieldName = foreignFieldName;
        }

        @Override
        public String getLocalTableName() {
            return this.localTableName;
        }

        @Override
        public String getLocalFieldName() {
            return this.localFieldName;
        }

        @Override
        public String getForeignTableName() {
            return this.foreignTableName;
        }

        @Override
        public String getForeignFieldName() {
            return this.foreignFieldName;
        }
    }

    private static final class FieldImpl
    implements Field {
        private final String name;
        private final DatabaseType<?> databaseType;
        private final int precision;
        private final int scale;
        private final boolean autoIncrement;
        private boolean notNull;
        private Object defaultValue;
        private boolean primaryKey;

        public FieldImpl(String name, DatabaseType<?> databaseType, int precision, int scale, boolean autoIncrement, boolean notNull) {
            this.name = name;
            this.databaseType = databaseType;
            this.precision = precision;
            this.scale = scale;
            this.autoIncrement = autoIncrement;
            this.notNull = notNull;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatabaseType<?> getDatabaseType() {
            return this.databaseType;
        }

        @Override
        public int getPrecision() {
            return this.precision;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        @Override
        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        @Override
        public boolean isNotNull() {
            return this.notNull;
        }

        public void setNotNull(boolean notNull) {
            this.notNull = notNull;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }
    }
}

