/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.base.Objects;
import net.java.ao.test.jdbc.JdbcConfiguration;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractJdbcConfiguration
implements JdbcConfiguration {
    public static final String DEFAULT_USER = "ao_user";
    public static final String DEFAULT_PASSWORD = "ao_password";
    private final String url;
    private final String username;
    private final String password;
    private final String schema;

    protected AbstractJdbcConfiguration(String url, String username, String password, String schema) {
        this.url = StringUtils.defaultString((String)url, (String)this.getDefaultUrl());
        this.username = StringUtils.defaultString((String)username, (String)this.getDefaultUsername());
        this.password = StringUtils.defaultString((String)password, (String)this.getDefaultPassword());
        this.schema = StringUtils.defaultString((String)schema, (String)this.getDefaultSchema());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    protected abstract String getDefaultSchema();

    protected abstract String getDefaultUrl();

    protected String getDefaultUsername() {
        return DEFAULT_USER;
    }

    protected String getDefaultPassword() {
        return DEFAULT_PASSWORD;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUsername(), this.getPassword(), this.getUrl(), this.getSchema()});
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JdbcConfiguration)) {
            return false;
        }
        JdbcConfiguration that = (JdbcConfiguration)obj;
        return this.getUsername().equals(that.getUsername()) && this.getPassword().equals(that.getPassword()) && this.getUrl().equals(that.getUrl()) && Objects.equal((Object)this.getSchema(), (Object)that.getSchema());
    }

    public final String toString() {
        return this.getUrl() + " :: " + (this.getSchema() != null ? this.getSchema() : "<no schema>") + " - " + this.getUsername() + " - " + this.getPassword();
    }
}

