/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseApplicationContext;
import net.java.truelicense.core.LicenseAuthorization;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseInitialization;
import net.java.truelicense.core.LicenseManagementContext;
import net.java.truelicense.core.LicenseParameters;
import net.java.truelicense.core.LicenseSubjectProvider;
import net.java.truelicense.core.LicenseValidation;
import net.java.truelicense.core.auth.Authentication;
import net.java.truelicense.core.auth.KeyStoreParameters;
import net.java.truelicense.core.auth.Repository;
import net.java.truelicense.core.auth.RepositoryProvider;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.crypto.Encryption;
import net.java.truelicense.core.crypto.PbeParameters;
import net.java.truelicense.core.io.FileStore;
import net.java.truelicense.core.io.PreferencesStore;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.io.Sources;
import net.java.truelicense.core.io.Store;
import net.java.truelicense.core.io.Transformation;
import net.java.truelicense.core.policy.PasswordPolicy;
import net.java.truelicense.core.policy.PasswordPolicyProvider;
import net.java.truelicense.core.policy.WeakPasswordException;
import net.java.truelicense.core.util.ClassLoaderProvider;
import net.java.truelicense.core.util.Clock;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Immutable
abstract class BasicLicenseApplicationContext
implements LicenseApplicationContext,
LicenseSubjectProvider,
PasswordPolicyProvider,
Clock,
ClassLoaderProvider {
    private final LicenseManagementContext context;
    static final /* synthetic */ boolean $assertionsDisabled;

    BasicLicenseApplicationContext(LicenseManagementContext licenseManagementContext) {
        if (!$assertionsDisabled && null == licenseManagementContext) {
            throw new AssertionError();
        }
        this.context = licenseManagementContext;
    }

    @Override
    public final String subject() {
        return this.context().subject();
    }

    @Override
    public final LicenseManagementContext context() {
        return this.context;
    }

    @Override
    public final PasswordPolicy policy() {
        return this.context().policy();
    }

    @Override
    public final Date now() {
        return this.context().now();
    }

    @Override
    @CheckForNull
    public final ClassLoader classLoader() {
        return this.context().classLoader();
    }

    final LicenseParameters consumerParameters(Authentication authentication, Encryption encryption) {
        if (authentication.parameters().forSigning()) {
            throw new IllegalArgumentException();
        }
        return this.parameters(authentication, encryption);
    }

    final LicenseParameters vendorParameters(Authentication authentication, Encryption encryption) {
        if (!authentication.parameters().forSigning()) {
            throw new IllegalArgumentException();
        }
        return this.parameters(authentication, encryption);
    }

    private LicenseParameters parameters(Authentication authentication, Encryption encryption) {
        LicenseManagementContext licenseManagementContext = this.context();
        return this.parameters(licenseManagementContext.initialization(), authentication, encryption);
    }

    final LicenseParameters ftpParameters(LicenseConsumerManager licenseConsumerManager, Authentication authentication, @CheckForNull Encryption encryption, final int n) {
        if (!authentication.parameters().forSigning()) {
            throw new IllegalArgumentException();
        }
        if (0 >= n) {
            throw new IllegalArgumentException();
        }
        LicenseInitialization licenseInitialization = new LicenseInitialization(){
            final LicenseInitialization delegate;
            {
                this.delegate = BasicLicenseApplicationContext.this.context().initialization();
            }

            @Override
            public void initialize(License license) {
                this.delegate.initialize(license);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(license.getIssued());
                license.setNotBefore(calendar.getTime());
                calendar.add(5, n);
                license.setNotAfter(calendar.getTime());
            }
        };
        return this.chainedParameters(licenseConsumerManager, licenseInitialization, authentication, encryption);
    }

    final LicenseParameters chainedParameters(LicenseConsumerManager licenseConsumerManager, Authentication authentication, @CheckForNull Encryption encryption) {
        if (authentication.parameters().forSigning()) {
            throw new IllegalArgumentException();
        }
        return this.chainedParameters(licenseConsumerManager, this.context().initialization(), authentication, encryption);
    }

    private LicenseParameters chainedParameters(LicenseConsumerManager licenseConsumerManager, LicenseInitialization licenseInitialization, Authentication authentication, @CheckForNull Encryption encryption) {
        return this.parameters(licenseInitialization, authentication, BasicLicenseApplicationContext.resolveEncryption(licenseConsumerManager, encryption));
    }

    private static Encryption resolveEncryption(LicenseConsumerManager licenseConsumerManager, @CheckForNull Encryption encryption) {
        return null != encryption ? encryption : licenseConsumerManager.parameters().encryption();
    }

    private LicenseParameters parameters(LicenseInitialization licenseInitialization, Authentication authentication, Encryption encryption) {
        LicenseManagementContext licenseManagementContext = this.context();
        return BasicLicenseApplicationContext.parameters(licenseManagementContext.authorization(), licenseInitialization, licenseManagementContext.validation(), licenseManagementContext, authentication, licenseManagementContext.codec(), licenseManagementContext.compression(), encryption);
    }

    private static LicenseParameters parameters(final LicenseAuthorization licenseAuthorization, final LicenseInitialization licenseInitialization, final LicenseValidation licenseValidation, final RepositoryProvider repositoryProvider, final Authentication authentication, final Codec codec, final Transformation transformation, final Encryption encryption) {
        Objects.requireNonNull(licenseAuthorization);
        Objects.requireNonNull(licenseInitialization);
        Objects.requireNonNull(licenseValidation);
        Objects.requireNonNull(authentication);
        Objects.requireNonNull(codec);
        Objects.requireNonNull(transformation);
        Objects.requireNonNull(encryption);
        return new LicenseParameters(){

            @Override
            public LicenseAuthorization authorization() {
                return licenseAuthorization;
            }

            @Override
            public LicenseInitialization initialization() {
                return licenseInitialization;
            }

            @Override
            public LicenseValidation validation() {
                return licenseValidation;
            }

            @Override
            public Repository repository() {
                return repositoryProvider.repository();
            }

            @Override
            public Authentication authentication() {
                return authentication;
            }

            @Override
            public Codec codec() {
                return codec;
            }

            @Override
            public Transformation compression() {
                return transformation;
            }

            @Override
            public Encryption encryption() {
                return encryption;
            }
        };
    }

    final KeyStoreParameters ksChecked(@CheckForNull Source source, @CheckForNull String string, ObfuscatedString obfuscatedString, String string2, ObfuscatedString obfuscatedString2) {
        KeyStoreParameters keyStoreParameters = this.ksUnchecked(source, string, obfuscatedString, string2, obfuscatedString2);
        this.check(keyStoreParameters.storePassword());
        this.check(keyStoreParameters.keyPassword());
        return keyStoreParameters;
    }

    final KeyStoreParameters ksUnchecked(final @CheckForNull Source source, final @CheckForNull String string, final ObfuscatedString obfuscatedString, final String string2, final @CheckForNull ObfuscatedString obfuscatedString2) {
        Objects.requireNonNull(obfuscatedString);
        Objects.requireNonNull(string2);
        return new KeyStoreParameters(){
            final String resolvedStoreType;
            {
                this.resolvedStoreType = BasicLicenseApplicationContext.this.resolveStoreType(string);
            }

            @Override
            public String storeType() {
                return this.resolvedStoreType;
            }

            @Override
            public Source source() {
                return source;
            }

            @Override
            public String alias() {
                return string2;
            }

            @Override
            public char[] storePassword() {
                return obfuscatedString.toCharArray();
            }

            @Override
            public char[] keyPassword() {
                return null == obfuscatedString2 ? null : obfuscatedString2.toCharArray();
            }

            @Override
            public boolean forSigning() {
                return null != obfuscatedString2;
            }
        };
    }

    private String resolveStoreType(@CheckForNull String string) {
        return null != string ? string : this.context().storeType();
    }

    final PbeParameters pbeChecked(@CheckForNull String string, ObfuscatedString obfuscatedString) {
        PbeParameters pbeParameters = this.pbeUnchecked(string, obfuscatedString);
        this.check(pbeParameters.password());
        return pbeParameters;
    }

    final PbeParameters pbeUnchecked(final @CheckForNull String string, final ObfuscatedString obfuscatedString) {
        Objects.requireNonNull(obfuscatedString);
        return new PbeParameters(){
            final String resolvedAlgorithm;
            {
                this.resolvedAlgorithm = BasicLicenseApplicationContext.this.resolvePbeAlgorithm(string);
            }

            @Override
            public String algorithm() {
                return this.resolvedAlgorithm;
            }

            @Override
            public char[] password() {
                return obfuscatedString.toCharArray();
            }
        };
    }

    private String resolvePbeAlgorithm(@CheckForNull String string) {
        return null != string ? string : this.context().pbeAlgorithm();
    }

    private void check(char[] cArray) {
        try {
            this.policy().check(cArray);
        }
        catch (WeakPasswordException weakPasswordException) {
            throw new IllegalArgumentException(weakPasswordException);
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    @Override
    public Source resource(String string) {
        return Sources.forResource(string, this.classLoader());
    }

    @Override
    public Store systemNodeStore(Class<?> clazz) {
        return new PreferencesStore(Preferences.systemNodeForPackage(clazz), this.subject());
    }

    @Override
    public Store userNodeStore(Class<?> clazz) {
        return new PreferencesStore(Preferences.userNodeForPackage(clazz), this.subject());
    }

    @Override
    public Store fileStore(File file) {
        return new FileStore(file);
    }

    static {
        BasicLicenseApplicationContext.$assertionsDisabled = !BasicLicenseApplicationContext.class.desiredAssertionStatus();
    }
}

