/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.io.File;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truelicense.core.BasicLicenseApplicationContext;
import net.java.truelicense.core.BasicLicenseManagementContext;
import net.java.truelicense.core.CachingLicenseConsumerManager;
import net.java.truelicense.core.ChainedLicenseConsumerManager;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseApplicationContext;
import net.java.truelicense.core.LicenseConsumerContext;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseParameters;
import net.java.truelicense.core.LicenseProvider;
import net.java.truelicense.core.auth.Authentication;
import net.java.truelicense.core.crypto.Encryption;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.io.Store;
import net.java.truelicense.core.util.CachePeriodProvider;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Immutable
final class BasicLicenseConsumerContext
extends BasicLicenseApplicationContext
implements LicenseConsumerContext,
CachePeriodProvider,
LicenseProvider {
    static final /* synthetic */ boolean $assertionsDisabled;

    BasicLicenseConsumerContext(BasicLicenseManagementContext basicLicenseManagementContext) {
        super(basicLicenseManagementContext);
    }

    @Override
    public long cachePeriodMillis() {
        return this.context().cachePeriodMillis();
    }

    @Override
    public License license() {
        return this.context().license();
    }

    @Override
    public Authentication keyStore(@CheckForNull Source source, @CheckForNull String string, ObfuscatedString obfuscatedString, String string2) {
        return this.context().authentication(this.ksUnchecked(source, string, obfuscatedString, string2, null));
    }

    @Override
    public Authentication ftpKeyStore(@CheckForNull Source source, @CheckForNull String string, ObfuscatedString obfuscatedString, String string2, ObfuscatedString obfuscatedString2) {
        return this.context().authentication(this.ksUnchecked(source, string, obfuscatedString, string2, obfuscatedString2));
    }

    @Override
    public Encryption pbe(@CheckForNull String string, ObfuscatedString obfuscatedString) {
        return this.context().encryption(this.pbeUnchecked(string, obfuscatedString));
    }

    @Override
    public LicenseConsumerManager manager(Authentication authentication, Encryption encryption, Store store) {
        return this.manager(this.consumerParameters(authentication, encryption), store);
    }

    private LicenseConsumerManager manager(final LicenseParameters licenseParameters, final Store store) {
        if (!$assertionsDisabled && null == licenseParameters) {
            throw new AssertionError();
        }
        Objects.requireNonNull(store);
        return new CachingManager(){

            @Override
            public LicenseParameters parameters() {
                return licenseParameters;
            }

            @Override
            public Store store() {
                return store;
            }
        };
    }

    @Override
    public LicenseConsumerManager ftpManager(LicenseConsumerManager licenseConsumerManager, Authentication authentication, @CheckForNull Encryption encryption, Store store, int n) {
        return this.chainedManager(licenseConsumerManager, this.ftpParameters(licenseConsumerManager, authentication, encryption, n), store);
    }

    @Override
    public LicenseConsumerManager chainedManager(LicenseConsumerManager licenseConsumerManager, Authentication authentication, @CheckForNull Encryption encryption, Store store) {
        return this.chainedManager(licenseConsumerManager, this.chainedParameters(licenseConsumerManager, authentication, encryption), store);
    }

    private LicenseConsumerManager chainedManager(final LicenseConsumerManager licenseConsumerManager, final LicenseParameters licenseParameters, final Store store) {
        if (!$assertionsDisabled && null == licenseParameters) {
            throw new AssertionError();
        }
        Objects.requireNonNull(licenseConsumerManager);
        Objects.requireNonNull(store);
        return new ChainedManager(){

            @Override
            public LicenseParameters parameters() {
                return licenseParameters;
            }

            @Override
            public Store store() {
                return store;
            }

            @Override
            LicenseConsumerManager parent() {
                return licenseConsumerManager;
            }
        };
    }

    @Override
    public LicenseConsumerContext.ManagerBuilder manager() {
        @NotThreadSafe
        class MB
        implements LicenseConsumerContext.ManagerBuilder {
            final LicenseConsumerContext cc;
            @Nullable
            LicenseConsumerManager parent;
            int days;
            @Nullable
            Authentication authentication;
            @Nullable
            Encryption encryption;
            @Nullable
            Store store;

            MB() {
                this.cc = BasicLicenseConsumerContext.this;
            }

            @Override
            public LicenseConsumerManager build() {
                if (null == this.parent) {
                    return this.cc.manager(this.authentication, this.encryption, this.store);
                }
                return 0 != this.days ? this.cc.ftpManager(this.parent, this.authentication, this.encryption, this.store, this.days) : this.cc.chainedManager(this.parent, this.authentication, this.encryption, this.store);
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder inject() {
                throw new UnsupportedOperationException();
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder parent(LicenseConsumerManager licenseConsumerManager) {
                this.parent = licenseConsumerManager;
                return this;
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder parent() {
                final MB mB = this;
                return new MB(){

                    @Override
                    public LicenseConsumerContext.ManagerBuilder inject() {
                        return mB.parent((LicenseConsumerManager)this.build());
                    }
                };
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder ftpDays(int n) {
                this.days = n;
                return this;
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder authentication(Authentication authentication) {
                this.authentication = authentication;
                return this;
            }

            @Override
            public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> keyStore() {
                return new LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder>(){
                    @Nullable
                    String storeType;
                    @Nullable
                    String alias;
                    @Nullable
                    Source source;
                    @Nullable
                    ObfuscatedString storePassword;
                    @Nullable
                    ObfuscatedString keyPassword;

                    @Override
                    public LicenseConsumerContext.ManagerBuilder inject() {
                        return this.authentication(null != this.keyPassword ? cc.ftpKeyStore(this.source, this.storeType, this.storePassword, this.alias, this.keyPassword) : cc.keyStore(this.source, this.storeType, this.storePassword, this.alias));
                    }

                    @Override
                    public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> storeType(@CheckForNull String string) {
                        this.storeType = string;
                        return this;
                    }

                    @Override
                    public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> loadFrom(Source source) {
                        this.source = source;
                        return this;
                    }

                    @Override
                    public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> loadFromResource(String string) {
                        return this.loadFrom(cc.resource(string));
                    }

                    @Override
                    public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> storePassword(ObfuscatedString obfuscatedString) {
                        this.storePassword = obfuscatedString;
                        return this;
                    }

                    @Override
                    public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> alias(String string) {
                        this.alias = string;
                        return this;
                    }

                    @Override
                    public LicenseApplicationContext.KsbaInjection<LicenseConsumerContext.ManagerBuilder> keyPassword(ObfuscatedString obfuscatedString) {
                        this.keyPassword = obfuscatedString;
                        return this;
                    }
                };
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder encryption(Encryption encryption) {
                this.encryption = encryption;
                return this;
            }

            @Override
            public LicenseApplicationContext.PbeInjection<LicenseConsumerContext.ManagerBuilder> pbe() {
                return new LicenseApplicationContext.PbeInjection<LicenseConsumerContext.ManagerBuilder>(){
                    @Nullable
                    String algorithm;
                    @Nullable
                    ObfuscatedString password;

                    @Override
                    public LicenseConsumerContext.ManagerBuilder inject() {
                        return this.encryption(cc.pbe(this.algorithm, this.password));
                    }

                    @Override
                    public LicenseApplicationContext.PbeInjection<LicenseConsumerContext.ManagerBuilder> algorithm(@CheckForNull String string) {
                        this.algorithm = string;
                        return this;
                    }

                    @Override
                    public LicenseApplicationContext.PbeInjection<LicenseConsumerContext.ManagerBuilder> password(ObfuscatedString obfuscatedString) {
                        this.password = obfuscatedString;
                        return this;
                    }
                };
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder storeIn(Store store) {
                this.store = store;
                return this;
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder storeInSystemNode(Class<?> clazz) {
                this.store = this.cc.systemNodeStore(clazz);
                return this;
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder storeInUserNode(Class<?> clazz) {
                this.store = this.cc.userNodeStore(clazz);
                return this;
            }

            @Override
            public LicenseConsumerContext.ManagerBuilder storeInFile(File file) {
                this.store = this.cc.fileStore(file);
                return this;
            }
        }
        return new MB();
    }

    static {
        BasicLicenseConsumerContext.$assertionsDisabled = !BasicLicenseConsumerContext.class.desiredAssertionStatus();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class ChainedManager
    extends ChainedLicenseConsumerManager
    implements LicenseConsumerManager {
        final BasicLicenseConsumerContext cc;
        final String subject;
        final long cachePeriodMillis;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ChainedManager() {
            this.cc = BasicLicenseConsumerContext.this;
            this.subject = this.cc.subject();
            this.cachePeriodMillis = this.cc.cachePeriodMillis();
            if (0L > this.cachePeriodMillis) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String subject() {
            return this.subject;
        }

        @Override
        public LicenseConsumerContext context() {
            return this.cc;
        }

        @Override
        public long cachePeriodMillis() {
            return this.cachePeriodMillis;
        }

        @Override
        public License license() {
            if (!$assertionsDisabled && !this.authentication().parameters().forSigning()) {
                throw new AssertionError();
            }
            return this.cc.license();
        }

        static {
            ChainedManager.$assertionsDisabled = !BasicLicenseConsumerContext.class.desiredAssertionStatus();
        }
    }

    private abstract class CachingManager
    extends CachingLicenseConsumerManager
    implements LicenseConsumerManager {
        final BasicLicenseConsumerContext cc;
        final String subject;
        final long cachePeriodMillis;

        private CachingManager() {
            this.cc = BasicLicenseConsumerContext.this;
            this.subject = this.cc.subject();
            this.cachePeriodMillis = this.cc.cachePeriodMillis();
            if (0L > this.cachePeriodMillis) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String subject() {
            return this.subject;
        }

        @Override
        public LicenseConsumerContext context() {
            return this.cc;
        }

        @Override
        public long cachePeriodMillis() {
            return this.cachePeriodMillis;
        }
    }
}

