/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.BasicLicenseAuthorization;
import net.java.truelicense.core.BasicLicenseConsumerContext;
import net.java.truelicense.core.BasicLicenseInitialization;
import net.java.truelicense.core.BasicLicenseValidation;
import net.java.truelicense.core.BasicLicenseVendorContext;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseAuthorization;
import net.java.truelicense.core.LicenseConsumerContext;
import net.java.truelicense.core.LicenseInitialization;
import net.java.truelicense.core.LicenseManagementContext;
import net.java.truelicense.core.LicenseValidation;
import net.java.truelicense.core.LicenseVendorContext;
import net.java.truelicense.core.auth.Authentication;
import net.java.truelicense.core.auth.KeyStoreParameters;
import net.java.truelicense.core.auth.Notary;
import net.java.truelicense.core.auth.Repository;
import net.java.truelicense.core.crypto.Encryption;
import net.java.truelicense.core.crypto.PbeParameters;
import net.java.truelicense.core.policy.PasswordPolicy;
import net.java.truelicense.core.util.Objects;

@Immutable
public abstract class BasicLicenseManagementContext
implements LicenseManagementContext {
    private final String subject;
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    protected BasicLicenseManagementContext(String string) {
        this.subject = Objects.requireNonNull(string);
    }

    @Override
    public final LicenseVendorContext vendor() {
        return new BasicLicenseVendorContext(this);
    }

    @Override
    public final LicenseConsumerContext consumer() {
        return new BasicLicenseConsumerContext(this);
    }

    @Override
    public abstract License license();

    @Override
    public final String subject() {
        return this.subject;
    }

    @Override
    public LicenseAuthorization authorization() {
        return new BasicLicenseAuthorization();
    }

    @Override
    public LicenseInitialization initialization() {
        return new BasicLicenseInitialization(this);
    }

    @Override
    public LicenseValidation validation() {
        return new BasicLicenseValidation(this);
    }

    @Override
    public abstract Repository repository();

    @Override
    public Authentication authentication(KeyStoreParameters keyStoreParameters) {
        return new Notary(keyStoreParameters);
    }

    @Override
    public abstract Encryption encryption(PbeParameters var1);

    @Override
    public PasswordPolicy policy() {
        return new PasswordPolicy();
    }

    @Override
    public Date now() {
        return new Date();
    }

    @Override
    @CheckForNull
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public long cachePeriodMillis() {
        return 1800000L;
    }
}

