/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.util.Date;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseManagementContext;
import net.java.truelicense.core.LicenseSubjectProvider;
import net.java.truelicense.core.LicenseValidation;
import net.java.truelicense.core.LicenseValidationException;
import net.java.truelicense.core.Messages;
import net.java.truelicense.core.util.Clock;
import net.java.truelicense.core.util.ContextProvider;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Immutable
final class BasicLicenseValidation
implements ContextProvider<LicenseManagementContext>,
LicenseValidation,
LicenseSubjectProvider,
Clock {
    private final LicenseManagementContext context;
    static final /* synthetic */ boolean $assertionsDisabled;

    BasicLicenseValidation(LicenseManagementContext licenseManagementContext) {
        if (!$assertionsDisabled && null == licenseManagementContext) {
            throw new AssertionError();
        }
        this.context = licenseManagementContext;
    }

    @Override
    public LicenseManagementContext context() {
        return this.context;
    }

    @Override
    public String subject() {
        return this.context().subject();
    }

    @Override
    public Date now() {
        return this.context().now();
    }

    @Override
    public void validate(License license) throws LicenseValidationException {
        if (0 >= license.getConsumerAmount()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.CONSUMER_AMOUNT_IS_NOT_POSITIVE(), license.getConsumerAmount()));
        }
        if (null == license.getConsumerType()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.CONSUMER_TYPE_IS_NULL(), new Object[0]));
        }
        if (null == license.getHolder()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.HOLDER_IS_NULL(), new Object[0]));
        }
        if (null == license.getIssued()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.ISSUED_IS_NULL(), new Object[0]));
        }
        if (null == license.getIssuer()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.ISSUER_IS_NULL(), new Object[0]));
        }
        Date date = this.now();
        Date date2 = license.getNotAfter();
        if (null != date2 && date.after(date2)) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.LICENSE_HAS_EXPIRED(), date2));
        }
        Date date3 = license.getNotBefore();
        if (null != date3 && date.before(date3)) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.LICENSE_IS_NOT_YET_VALID(), date3));
        }
        if (!this.subject().equals(license.getSubject())) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.INVALID_SUBJECT(), license.getSubject(), this.subject()));
        }
    }

    static {
        BasicLicenseValidation.$assertionsDisabled = !BasicLicenseValidation.class.desiredAssertionStatus();
    }

    static final /* synthetic */ String INVALID_SUBJECT() {
        return new ObfuscatedString(new long[]{-6466209646643388459L, -7235959843023116362L, 1390275139721698081L}).toString();
    }

    static final /* synthetic */ String HOLDER_IS_NULL() {
        return new ObfuscatedString(new long[]{-1779368033948657659L, 3672028209806670608L, 1735003935737981998L}).toString();
    }

    static final /* synthetic */ String ISSUER_IS_NULL() {
        return new ObfuscatedString(new long[]{5892851644799574394L, -7822042852648038188L, -319834378269254594L}).toString();
    }

    static final /* synthetic */ String ISSUED_IS_NULL() {
        return new ObfuscatedString(new long[]{-7975912492600603798L, -2612276340289062025L, 2570473436523224515L}).toString();
    }

    static final /* synthetic */ String LICENSE_IS_NOT_YET_VALID() {
        return new ObfuscatedString(new long[]{421536062790850969L, -5884756733678615202L, -6881863570709765680L, -66300744384651676L}).toString();
    }

    static final /* synthetic */ String LICENSE_HAS_EXPIRED() {
        return new ObfuscatedString(new long[]{3941129409617143905L, -7249937270170735927L, 3456554582821295910L, 5834421928737174377L}).toString();
    }

    static final /* synthetic */ String CONSUMER_TYPE_IS_NULL() {
        return new ObfuscatedString(new long[]{20318608932123846L, -3659650926875344749L, 8861263301186740421L, 4496319283430014563L}).toString();
    }

    static final /* synthetic */ String CONSUMER_AMOUNT_IS_NOT_POSITIVE() {
        return new ObfuscatedString(new long[]{-4626809448029517400L, 4853189281388761439L, -4376461830096832324L, -3180781475748694800L, 1502885916940421489L}).toString();
    }
}

