/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import javax.annotation.concurrent.ThreadSafe;
import net.java.truelicense.core.CachingLicenseConsumerManager;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.LicenseProvider;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.io.Store;

@ThreadSafe
abstract class ChainedLicenseConsumerManager
extends CachingLicenseConsumerManager
implements LicenseProvider {
    ChainedLicenseConsumerManager() {
    }

    abstract LicenseConsumerManager parent();

    private boolean ftp() {
        return this.authentication().parameters().forSigning();
    }

    @Override
    public License install(Source source) throws LicenseManagementException {
        try {
            return this.parent().install(source);
        }
        catch (LicenseManagementException licenseManagementException) {
            if (this.ftp()) {
                throw licenseManagementException;
            }
            return super.install(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public License view() throws LicenseManagementException {
        try {
            return this.parent().view();
        }
        catch (LicenseManagementException licenseManagementException) {
            try {
                return super.view();
            }
            catch (LicenseManagementException licenseManagementException2) {
                Store store = this.store();
                synchronized (store) {
                    try {
                        return super.view();
                    }
                    catch (LicenseManagementException licenseManagementException3) {
                        return this.createIffNewFtp(licenseManagementException3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() throws LicenseManagementException {
        try {
            this.parent().verify();
        }
        catch (LicenseManagementException licenseManagementException) {
            try {
                super.verify();
            }
            catch (LicenseManagementException licenseManagementException2) {
                Store store = this.store();
                synchronized (store) {
                    try {
                        super.verify();
                    }
                    catch (LicenseManagementException licenseManagementException3) {
                        this.createIffNewFtp(licenseManagementException3);
                    }
                }
            }
        }
    }

    @Override
    public void uninstall() throws LicenseManagementException {
        LicenseConsumerManager licenseConsumerManager = this.parent();
        try {
            licenseConsumerManager.uninstall();
        }
        catch (LicenseManagementException licenseManagementException) {
            if (this.ftp()) {
                throw licenseManagementException;
            }
            super.uninstall();
        }
    }

    private License createIffNewFtp(LicenseManagementException licenseManagementException) throws LicenseManagementException {
        if (!this.ftp()) {
            throw licenseManagementException;
        }
        Store store = this.store();
        if (store.exists()) {
            throw licenseManagementException;
        }
        return super.create(this.license(), store);
    }
}

