/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.util.Calendar;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.truelicense.core.codec.X500PrincipalXmlAdapter;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@XmlRootElement(name="license")
@XmlType(name="license")
@Nullable
public class License {
    private int consumerAmount = 1;
    private String consumerType;
    private Object extra;
    private X500Principal holder;
    private String info;
    private Date issued;
    private X500Principal issuer;
    private Date notAfter;
    private Date notBefore;
    private String subject;

    @XmlElement(defaultValue="1")
    public final int getConsumerAmount() {
        return this.consumerAmount;
    }

    public final void setConsumerAmount(int n) {
        this.consumerAmount = n;
    }

    @XmlElement(required=true)
    public final String getConsumerType() {
        return this.consumerType;
    }

    public final void setConsumerType(String string) {
        this.consumerType = string;
    }

    public final Object getExtra() {
        return this.extra;
    }

    public final void setExtra(Object object) {
        this.extra = object;
    }

    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=X500PrincipalXmlAdapter.class)
    public final X500Principal getHolder() {
        return this.holder;
    }

    public final void setHolder(X500Principal x500Principal) {
        this.holder = x500Principal;
    }

    public final String getInfo() {
        return this.info;
    }

    public final void setInfo(String string) {
        this.info = string;
    }

    @XmlElement(required=true)
    public final Date getIssued() {
        return License.clone(this.issued);
    }

    public final void setIssued(Date date) {
        this.issued = License.clone(date);
    }

    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=X500PrincipalXmlAdapter.class)
    public final X500Principal getIssuer() {
        return this.issuer;
    }

    public final void setIssuer(X500Principal x500Principal) {
        this.issuer = x500Principal;
    }

    public final Date getNotAfter() {
        return License.clone(this.notAfter);
    }

    public final void setNotAfter(Date date) {
        this.notAfter = License.clone(date);
    }

    public final Date getNotBefore() {
        return License.clone(this.notBefore);
    }

    public final void setNotBefore(Date date) {
        this.notBefore = License.clone(date);
    }

    public final void setTerm(int n) {
        Date date = this.getIssued();
        if (null == date) {
            date = new Date();
            this.setIssued(date);
        }
        this.setNotBefore(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        this.setNotAfter(calendar.getTime());
    }

    @XmlElement(required=true)
    public final String getSubject() {
        return this.subject;
    }

    public final void setSubject(String string) {
        this.subject = string;
    }

    private static Date clone(Date date) {
        return null == date ? null : (Date)date.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof License)) {
            return false;
        }
        License license = (License)object;
        return this.consumerAmount == license.consumerAmount && Objects.equals(this.consumerType, license.consumerType) && Objects.equals(this.extra, license.extra) && Objects.equals(this.holder, license.holder) && Objects.equals(this.info, license.info) && Objects.equals(this.issued, license.issued) && Objects.equals(this.issuer, license.issuer) && Objects.equals(this.notAfter, license.notAfter) && Objects.equals(this.notBefore, license.notBefore) && Objects.equals(this.subject, license.subject);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.consumerAmount;
        n = 31 * n + Objects.hashCode(this.consumerType);
        n = 31 * n + Objects.hashCode(this.extra);
        n = 31 * n + Objects.hashCode(this.holder);
        n = 31 * n + Objects.hashCode(this.info);
        n = 31 * n + Objects.hashCode(this.issued);
        n = 31 * n + Objects.hashCode(this.issuer);
        n = 31 * n + Objects.hashCode(this.notAfter);
        n = 31 * n + Objects.hashCode(this.notBefore);
        n = 31 * n + Objects.hashCode(this.subject);
        return n;
    }

    public String toString() {
        return String.format(License._string#0(), this.getClass().getName(), this.hashCode(), License.literal(this.getSubject()), License.literal(this.getHolder()), License.literal(this.getIssuer()), this.getIssued(), this.getNotBefore(), this.getNotAfter(), License.literal(this.getConsumerType()), this.getConsumerAmount(), License.literal(this.getInfo()));
    }

    @Nullable
    private static String literal(@CheckForNull Object object) {
        if (null == object) {
            return null;
        }
        String string = object.toString();
        return '\"' + string.replace(License._string#1(), License._string#2()).replace(License._string#3(), License._string#4()) + '\"';
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{-8135099895275744941L, -703232755178608323L, 9170357033138807567L, 7823817043506057240L, 3661718522576810693L, -26507747237562827L, -3848656950490573780L, 1996068887464643106L, -4709578134893444886L, -4654352459964064547L, 3265018328184179917L, -706141926251213489L, -6341927543858515712L, 2378899872960880890L, -6041343116828722191L, 1814136427518099432L, -4711526146419105630L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{-3041808235593158680L, 4010167913024067239L}).toString();
    }

    private static /* synthetic */ String _string#2() {
        return new ObfuscatedString(new long[]{7001514329465160639L, -4693420912396111838L}).toString();
    }

    private static /* synthetic */ String _string#3() {
        return new ObfuscatedString(new long[]{-5364417920209018925L, -6958515870686452998L}).toString();
    }

    private static /* synthetic */ String _string#4() {
        return new ObfuscatedString(new long[]{-1096315162478709645L, -7521672122961025218L}).toString();
    }
}

