/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.Immutable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.PBEParameterSpec;
import net.java.truelicense.core.crypto.BasicPbeEncryption;
import net.java.truelicense.core.crypto.PbeParameters;
import net.java.truelicense.core.io.Sink;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.obfuscate.ObfuscatedString;

@Immutable
final class V1Encryption
extends BasicPbeEncryption {
    V1Encryption(PbeParameters pbeParameters) {
        super(pbeParameters);
        if (!V1Encryption.PBE_ALGORITHM().equalsIgnoreCase(pbeParameters.algorithm())) {
            throw new IllegalArgumentException(V1Encryption.ILLEGAL_PBE_ALGORITHM());
        }
    }

    @Override
    public Sink apply(final Sink sink) {
        return new Sink(){

            @Override
            public OutputStream output() throws IOException {
                return (OutputStream)V1Encryption.wrap(new Callable<OutputStream>(){

                    @Override
                    public OutputStream call() throws Exception {
                        Cipher cipher = V1Encryption.this.cipher(true);
                        return new CipherOutputStream(sink.output(), cipher);
                    }
                });
            }
        };
    }

    @Override
    public Source unapply(final Source source) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return (InputStream)V1Encryption.wrap(new Callable<InputStream>(){

                    @Override
                    public InputStream call() throws Exception {
                        Cipher cipher = V1Encryption.this.cipher(false);
                        return new CipherInputStream(source.input(), cipher);
                    }
                });
            }
        };
    }

    private Cipher cipher(boolean bl) throws Exception {
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(new byte[]{-50, -5, -34, -84, 5, 2, 25, 113}, 2005);
        Cipher cipher = Cipher.getInstance(this.algorithm());
        cipher.init(bl ? 1 : 2, (Key)this.secretKey(), pBEParameterSpec);
        return cipher;
    }

    private static final /* synthetic */ String PBE_ALGORITHM() {
        return new ObfuscatedString(new long[]{-2524146958818755437L, 4112250824606349742L, 3789447420891997848L}).toString();
    }

    private static final /* synthetic */ String ILLEGAL_PBE_ALGORITHM() {
        return new ObfuscatedString(new long[]{519787219957315044L, -7448144615555532710L, -8403047845560182648L, -8176998356884560824L, 4189320075105577154L, 2112951828815672893L, -2638240122442349060L, -6567132173760759146L, 6200555161665714894L}).toString();
    }
}

