/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.auth;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.auth.Artifactory;
import net.java.truelicense.core.auth.Authentication;
import net.java.truelicense.core.auth.KeyStoreParameters;
import net.java.truelicense.core.auth.Messages;
import net.java.truelicense.core.auth.NotaryException;
import net.java.truelicense.core.auth.Repository;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.util.Message;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Immutable
public final class Notary
implements Authentication {
    private final KeyStoreParameters ksp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Notary(KeyStoreParameters keyStoreParameters) {
        this.ksp = Objects.requireNonNull(keyStoreParameters);
    }

    @Override
    public KeyStoreParameters parameters() {
        return this.ksp;
    }

    private Source source() {
        return this.parameters().source();
    }

    private String storeType() {
        return this.parameters().storeType();
    }

    private char[] storePassword() {
        return this.parameters().storePassword();
    }

    private String alias() {
        return this.parameters().alias();
    }

    @CheckForNull
    private char[] keyPassword() {
        return this.parameters().keyPassword();
    }

    private boolean forSigning() {
        return this.parameters().forSigning();
    }

    @Nullable
    private InputStream input() throws IOException {
        Source source = this.source();
        return null == source ? null : source.input();
    }

    @Override
    public Artifactory sign(Codec codec, Repository repository, @Nullable Object object) throws Exception {
        return repository.sign(codec, this.engine(), this.privateKey(), object);
    }

    @Override
    public Artifactory verify(Codec codec, Repository repository) throws Exception {
        return repository.verify(codec, this.engine(), this.publicKey());
    }

    private Signature engine() throws Exception {
        return Signature.getInstance(this.algorithm());
    }

    private String algorithm() throws Exception {
        Certificate certificate = this.certificate();
        if (certificate instanceof X509Certificate) {
            return ((X509Certificate)certificate).getSigAlgName();
        }
        return Notary.DEFAULT_ALGORITHM();
    }

    private PrivateKey privateKey() throws Exception {
        KeyStore.Entry entry = this.entry();
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            return ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
        }
        throw new NotaryException(this.message(Notary.NO_PRIVATE_KEY()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey publicKey() throws Exception {
        Certificate certificate = this.certificate();
        PublicKey publicKey = certificate.getPublicKey();
        if (!this.forSigning()) {
            InputStream inputStream = Notary.class.getResourceAsStream(publicKey.getAlgorithm());
            if (!$assertionsDisabled && null == inputStream) {
                throw new AssertionError();
            }
            try {
                certificate.verify(CertificateFactory.getInstance(Notary.X_509()).generateCertificate(inputStream).getPublicKey());
            }
            catch (SignatureException signatureException) {
                Logger.getAnonymousLogger(Messages.class.getName()).log(new Level(Notary.NOTICE(), Level.WARNING.intValue(), Messages.class.getName()){}, Notary.AGPL3());
            }
            finally {
                inputStream.close();
            }
        }
        return publicKey;
    }

    private Certificate certificate() throws Exception {
        KeyStore.Entry entry = this.entry();
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            return ((KeyStore.PrivateKeyEntry)entry).getCertificate();
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            return ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
        }
        throw new NotaryException(this.message(Notary.NO_CERTIFICATE()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore.Entry entry() throws Exception {
        KeyStore keyStore = this.keyStore();
        String string = this.alias();
        char[] cArray = this.keyPassword();
        if (null != cArray) {
            try {
                if (keyStore.isKeyEntry(string)) {
                    KeyStore.Entry entry;
                    KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
                    try {
                        entry = keyStore.getEntry(string, passwordProtection);
                    }
                    catch (Throwable throwable) {
                        passwordProtection.destroy();
                        throw throwable;
                    }
                    passwordProtection.destroy();
                    return entry;
                }
            }
            finally {
                Arrays.fill(cArray, '\u0000');
            }
            if (keyStore.isCertificateEntry(string)) {
                throw new NotaryException(this.message(Notary.SUPERFLUOUS_PASSWORD()));
            }
        } else {
            if (keyStore.isKeyEntry(string)) {
                throw new NotaryException(this.message(Notary.MISSING_PASSWORD()));
            }
            if (keyStore.isCertificateEntry(string)) {
                return keyStore.getEntry(string, null);
            }
        }
        if (!$assertionsDisabled && keyStore.containsAlias(string)) {
            throw new AssertionError();
        }
        throw new NotaryException(this.message(Notary.NO_SUCH_ENTRY()));
    }

    private Message message(String string) {
        return Messages.message(string, this.alias());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore keyStore() throws Exception {
        char[] cArray = this.storePassword();
        if (null == cArray) {
            throw new NotaryException(this.message(Notary.NO_STORE_PASSWORD()));
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(this.storeType());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.input(), 8192);
            try {
                keyStore.load(bufferedInputStream, cArray);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    static {
        Notary.$assertionsDisabled = !Notary.class.desiredAssertionStatus();
    }

    private static final /* synthetic */ String DEFAULT_ALGORITHM() {
        return new ObfuscatedString(new long[]{-1608320067008670155L, -6747881695497095790L, 3868853005205240208L}).toString();
    }

    static final /* synthetic */ String NO_STORE_PASSWORD() {
        return new ObfuscatedString(new long[]{4285236791591936692L, 8388748798189035973L, -6372326003351347781L}).toString();
    }

    static final /* synthetic */ String NO_PRIVATE_KEY() {
        return new ObfuscatedString(new long[]{-5904703188763416485L, 137578986946132230L, 7554526896824236791L}).toString();
    }

    static final /* synthetic */ String NO_CERTIFICATE() {
        return new ObfuscatedString(new long[]{-8286999745848835466L, 6722131626036117415L, -6176328888825396529L}).toString();
    }

    static final /* synthetic */ String MISSING_PASSWORD() {
        return new ObfuscatedString(new long[]{2106400270309402904L, -6179666807988487976L, -9084839828347188093L}).toString();
    }

    static final /* synthetic */ String SUPERFLUOUS_PASSWORD() {
        return new ObfuscatedString(new long[]{2404564301439429609L, 7685743582539173116L, 4459285365080908345L, 5468462105223448288L}).toString();
    }

    static final /* synthetic */ String NO_SUCH_ENTRY() {
        return new ObfuscatedString(new long[]{5945047590270139047L, 1186385292137758754L, -4225042721968024980L}).toString();
    }

    static final /* synthetic */ String AGPL3() {
        return new ObfuscatedString(new long[]{-8422649190383757354L, -7419257293753622311L}).toString();
    }

    private static final /* synthetic */ String X_509() {
        return new ObfuscatedString(new long[]{-1167381998359555600L, 2484231151183047579L}).toString();
    }

    private static final /* synthetic */ String NOTICE() {
        return new ObfuscatedString(new long[]{1385574062766102874L, 637260877996170883L}).toString();
    }
}

