/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.codec;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import net.java.truelicense.core.codec.BinaryCodecException;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.obfuscate.ObfuscatedString;
import org.apache.commons.codec.Charsets;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Codecs {
    private static final Pattern CHARSET_PATTERN;
    static final /* synthetic */ boolean $assertionsDisabled;

    @CheckForNull
    public static Charset charset(Codec codec) {
        try {
            return Codecs.contentTransferCharset(codec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @CheckForNull
    public static Charset contentTransferCharset(Codec codec) {
        String string = codec.contentTransferEncoding();
        if (Codecs._7BIT().equalsIgnoreCase(string) || Codecs.QUOTED_PRINTABLE().equalsIgnoreCase(string) || Codecs.BASE64().equalsIgnoreCase(string)) {
            return Charsets.US_ASCII;
        }
        if (Codecs._8BIT().equalsIgnoreCase(string)) {
            Matcher matcher = CHARSET_PATTERN.matcher(codec.contentType());
            if (matcher.find()) {
                if (!$assertionsDisabled && 2 != matcher.groupCount()) {
                    throw new AssertionError();
                }
                String string2 = matcher.group(1);
                if (null == string2) {
                    string2 = matcher.group(2);
                }
                return Charset.forName(string2);
            }
            return Charsets.UTF_8;
        }
        throw new BinaryCodecException(Codecs._string#6() + string + Codecs._string#7());
    }

    private Codecs() {
    }

    private static /* synthetic */ void _clinit@1396987007361#0() {
        $assertionsDisabled = !Codecs.class.desiredAssertionStatus();
        CHARSET_PATTERN = Pattern.compile(Codecs.CHARSET_REGEXP(), 2);
    }

    static {
        Codecs._clinit@1396987007361#0();
    }

    static final /* synthetic */ String APPLICATION_XML_WITH_UTF_8() {
        return new ObfuscatedString(new long[]{-5162337152270399622L, 6430465356773760449L, 4173215625739280411L, -7185465121287212509L, -4420902889161110250L}).toString();
    }

    static final /* synthetic */ String _7BIT() {
        return new ObfuscatedString(new long[]{3099490211995193947L, -6947594649098236511L}).toString();
    }

    static final /* synthetic */ String _8BIT() {
        return new ObfuscatedString(new long[]{7033859277688785647L, 964067293131252130L}).toString();
    }

    static final /* synthetic */ String QUOTED_PRINTABLE() {
        return new ObfuscatedString(new long[]{-5889420775290741794L, 6571499958061262220L, -7891989406417170839L}).toString();
    }

    static final /* synthetic */ String BASE64() {
        return new ObfuscatedString(new long[]{7147676156928206511L, 6088468527932926582L}).toString();
    }

    private static final /* synthetic */ String CHARSET_REGEXP() {
        return new ObfuscatedString(new long[]{-189162163122900108L, 5205601191972439851L, -7918823382837359350L, -3501754030328164372L, -5928694193143689260L, -7346003718381822352L, 4829155449158985346L, -2793684973374378464L, -2093951337469617525L}).toString();
    }

    private static /* synthetic */ String _string#6() {
        return new ObfuscatedString(new long[]{4276975398643348657L, 2460084581923091540L, 4025649760528287496L, -8515691950974820411L, -8250880249995522989L}).toString();
    }

    private static /* synthetic */ String _string#7() {
        return new ObfuscatedString(new long[]{2968925038781766363L, -8229448252760512355L, -6279582133658909375L, 3047187686089559823L}).toString();
    }
}

