/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.crypto;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.Immutable;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.java.truelicense.core.crypto.Encryption;
import net.java.truelicense.core.crypto.PbeParameters;
import net.java.truelicense.core.util.Objects;

@Immutable
public abstract class BasicPbeEncryption
implements Encryption {
    private final PbeParameters pbe;

    protected BasicPbeEncryption(PbeParameters pbeParameters) {
        this.pbe = Objects.requireNonNull(pbeParameters);
    }

    @Override
    public final PbeParameters parameters() {
        return this.pbe;
    }

    protected final char[] password() {
        return this.parameters().password();
    }

    protected final String algorithm() {
        return this.parameters().algorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SecretKey secretKey() throws Exception {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password());
        try {
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            return secretKey;
        }
        finally {
            pBEKeySpec.clearPassword();
        }
    }

    protected static <V> V wrap(Callable<V> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }
}

