/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.truelicense.core.io.Store;

public final class MemoryStore
implements Store {
    private final int bufsize;
    private byte[] buffer;

    public MemoryStore() {
        this(8192);
    }

    public MemoryStore(int n) {
        this.bufsize = n;
        if (0 > this.bufsize) {
            throw new IllegalArgumentException();
        }
    }

    private static byte[] clone(@CheckForNull byte[] byArray) {
        return null == byArray ? null : (byte[])byArray.clone();
    }

    private byte[] checkedData() throws FileNotFoundException {
        if (null == this.buffer) {
            throw new FileNotFoundException();
        }
        return this.buffer;
    }

    @Nullable
    public byte[] data() {
        return MemoryStore.clone(this.buffer);
    }

    public void data(@CheckForNull byte[] byArray) {
        this.buffer = MemoryStore.clone(byArray);
    }

    @Override
    public InputStream input() throws IOException {
        return new ByteArrayInputStream(this.checkedData());
    }

    @Override
    public OutputStream output() throws IOException {
        return new ByteArrayOutputStream(this.bufsize){

            @Override
            public void close() throws IOException {
                MemoryStore.access$002(MemoryStore.this, this.toByteArray());
            }
        };
    }

    @Override
    public void delete() throws IOException {
        this.checkedData();
        this.buffer = null;
    }

    @Override
    public boolean exists() {
        return null != this.buffer;
    }

    static /* synthetic */ byte[] access$002(MemoryStore memoryStore, byte[] byArray) {
        memoryStore.buffer = byArray;
        return byArray;
    }
}

