/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.truelicense.core.io.Store;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PreferencesStore
implements Store {
    private final Preferences prefs;
    private final String key;

    public PreferencesStore(Preferences preferences) {
        this(preferences, PreferencesStore.PREFERENCES_KEY());
    }

    public PreferencesStore(Preferences preferences, String string) {
        this.prefs = Objects.requireNonNull(preferences);
        this.key = Objects.requireNonNull(string);
    }

    public boolean isUserNode() {
        return this.prefs.isUserNode();
    }

    private byte[] checkedData() throws FileNotFoundException {
        byte[] byArray = this.data();
        if (null == byArray) {
            throw new FileNotFoundException(PreferencesStore._string#1() + this.key + PreferencesStore._string#2() + (this.isUserNode() ? PreferencesStore._string#3() : PreferencesStore._string#4()) + PreferencesStore._string#5() + this.prefs.absolutePath() + PreferencesStore._string#6());
        }
        return byArray;
    }

    @Nullable
    public byte[] data() {
        return this.prefs.getByteArray(this.key, null);
    }

    public void data(@CheckForNull byte[] byArray) {
        if (null != byArray) {
            this.prefs.putByteArray(this.key, byArray);
        } else {
            this.prefs.remove(this.key);
        }
    }

    @Override
    public InputStream input() throws IOException {
        return new ByteArrayInputStream(this.checkedData());
    }

    @Override
    public OutputStream output() throws IOException {
        return new ByteArrayOutputStream(8192){

            @Override
            public void close() throws IOException {
                PreferencesStore.this.data(this.toByteArray());
                PreferencesStore.this.sync();
            }
        };
    }

    @Override
    public void delete() throws IOException {
        this.checkedData();
        this.data(null);
        this.sync();
    }

    private void sync() throws IOException {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException);
        }
    }

    @Override
    public boolean exists() {
        return null != this.data();
    }

    private static final /* synthetic */ String PREFERENCES_KEY() {
        return new ObfuscatedString(new long[]{6762359424836436475L, 8511693495584074315L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{-5047278084404467823L, -3660383613849204719L, -2554553613538886360L, -814724295420383432L}).toString();
    }

    private static /* synthetic */ String _string#2() {
        return new ObfuscatedString(new long[]{7730971223823301734L, -1337534252191603838L, 2269916565488333758L}).toString();
    }

    private static /* synthetic */ String _string#3() {
        return new ObfuscatedString(new long[]{-1331579802739017083L, 5575204357416418664L}).toString();
    }

    private static /* synthetic */ String _string#4() {
        return new ObfuscatedString(new long[]{-1405407987061239736L, 3946064716217649895L}).toString();
    }

    private static /* synthetic */ String _string#5() {
        return new ObfuscatedString(new long[]{991065194343201729L, 4142145577476117743L, 489057983579339572L, -8329262352879845307L, -232046777567178732L, 5617050079408659942L, -6433166595843073258L}).toString();
    }

    private static /* synthetic */ String _string#6() {
        return new ObfuscatedString(new long[]{2481408262023155159L, 552031068366387537L}).toString();
    }
}

