/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.x500;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.security.auth.x500.X500Principal;
import net.java.truelicense.core.util.Builder;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.core.x500.X500AttributeTypeKeyword;
import net.java.truelicense.obfuscate.ObfuscatedString;

public abstract class GenericX500PrincipalBuilder<This extends GenericX500PrincipalBuilder<This>>
implements Builder<X500Principal> {
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, String> keywords = new HashMap<String, String>();

    public This addCN(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.CN, string);
    }

    public This addL(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.L, string);
    }

    public This addST(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.ST, string);
    }

    public This addO(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.O, string);
    }

    public This addOU(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.OU, string);
    }

    public This addC(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.C, string);
    }

    public This addSTREET(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.STREET, string);
    }

    public This addDC(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.DC, string);
    }

    public This addUID(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.UID, string);
    }

    public This addT(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.T, string);
    }

    public This addDNQ(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.DNQ, string);
    }

    public This addDNQUALIFIER(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.DNQUALIFIER, string);
    }

    public This addSURNAME(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.SURNAME, string);
    }

    public This addGIVENNAME(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.GIVENNAME, string);
    }

    public This addINITIALS(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.INITIALS, string);
    }

    public This addGENERATION(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.GENERATION, string);
    }

    public This addEMAILADDRESS(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.EMAILADDRESS, string);
    }

    public This addSERIALNUMBER(@CheckForNull String string) {
        return this.addAttribute(X500AttributeTypeKeyword.SERIALNUMBER, string);
    }

    public This addAttribute(X500AttributeTypeKeyword x500AttributeTypeKeyword, @CheckForNull String string) {
        return this.addAttribute(x500AttributeTypeKeyword.name(), string);
    }

    public This addAttribute(String string, @CheckForNull String string2) {
        Objects.requireNonNull(string);
        if (null != string2) {
            this.attributes.put(string, string2);
        } else {
            this.attributes.remove(string);
        }
        return (This)this;
    }

    public This addKeyword(String string, @CheckForNull String string2) {
        Objects.requireNonNull(string);
        if (null != string2) {
            this.keywords.put(string, string2);
        } else {
            this.keywords.remove(string);
        }
        return (This)this;
    }

    @Override
    public X500Principal build() {
        DistinguishedNameAssembler distinguishedNameAssembler = new DistinguishedNameAssembler();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            distinguishedNameAssembler.appendAttribute(entry.getKey(), entry.getValue());
        }
        return new X500Principal(distinguishedNameAssembler.toString(), this.keywords);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class DistinguishedNameAssembler {
        private static final Pattern QUOTED_CHARACTERS_PATTERN;
        private final StringBuilder dname = new StringBuilder();

        private DistinguishedNameAssembler() {
        }

        void appendAttribute(String string, String string2) {
            this.delimitAttribute();
            this.dname.append(string).append('=');
            boolean bl = DistinguishedNameAssembler.needsQuoting(string2);
            if (bl) {
                this.dname.append('\"');
            }
            this.dname.append(DistinguishedNameAssembler.escapeBackslashAndQuote(string2));
            if (bl) {
                this.dname.append('\"');
            }
        }

        private void delimitAttribute() {
            if (0 < this.dname.length()) {
                this.dname.append(',');
            }
        }

        private static boolean needsQuoting(String string) {
            return !string.equals(string.trim()) || string.startsWith(DistinguishedNameAssembler._string#1()) || QUOTED_CHARACTERS_PATTERN.matcher(string).matches();
        }

        private static String escapeBackslashAndQuote(String string) {
            return string.replace(DistinguishedNameAssembler._string#2(), DistinguishedNameAssembler._string#3()).replace(DistinguishedNameAssembler._string#4(), DistinguishedNameAssembler._string#5());
        }

        public String toString() {
            return this.dname.toString();
        }

        static {
            DistinguishedNameAssembler.QUOTED_CHARACTERS_PATTERN = Pattern.compile(DistinguishedNameAssembler._string#6());
        }

        private static final /* synthetic */ String QUOTED_CHARACTERS_SEQUENCE() {
            return new ObfuscatedString(new long[]{1726281888190676918L, -8348776116745152552L}).toString();
        }

        private static /* synthetic */ String _string#1() {
            return new ObfuscatedString(new long[]{-3352591069364180576L, 5389894586775327685L}).toString();
        }

        private static /* synthetic */ String _string#2() {
            return new ObfuscatedString(new long[]{-4669101300503277156L, 6276617119593053059L}).toString();
        }

        private static /* synthetic */ String _string#3() {
            return new ObfuscatedString(new long[]{-1429501724185816097L, 1169607608601269655L}).toString();
        }

        private static /* synthetic */ String _string#4() {
            return new ObfuscatedString(new long[]{1453951122010588754L, -1043764884866207181L}).toString();
        }

        private static /* synthetic */ String _string#5() {
            return new ObfuscatedString(new long[]{-234302179124818434L, -3918693246862585310L}).toString();
        }

        private static /* synthetic */ String _string#6() {
            return new ObfuscatedString(new long[]{2633554327196332018L, -8021720789489064746L, 8467964899555776700L}).toString();
        }
    }
}

