/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.json.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.io.Sink;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

@Immutable
public class JsonCodec
implements Codec {
    private final ObjectMapper mapper;

    public JsonCodec(ObjectMapper objectMapper) {
        this.mapper = (ObjectMapper)Objects.requireNonNull((Object)objectMapper);
    }

    public String contentType() {
        return JsonCodec.CONTENT_TYPE();
    }

    public String contentTransferEncoding() {
        return JsonCodec.CONTENT_TRANSFER_ENCODING();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Sink sink, @Nullable Object object) throws Exception {
        OutputStream outputStream = sink.output();
        try {
            this.mapper.writeValue(outputStream, object);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T decode(Source source, Type type) throws Exception {
        InputStream inputStream = source.input();
        try {
            Object object = this.mapper.readValue(inputStream, this.mapper.constructType(type));
            return (T)object;
        }
        finally {
            inputStream.close();
        }
    }

    private static final /* synthetic */ String CONTENT_TYPE() {
        return new ObfuscatedString(new long[]{1774593270804863455L, 7785893008476645637L, -1716873975452299578L}).toString();
    }

    private static final /* synthetic */ String CONTENT_TRANSFER_ENCODING() {
        return new ObfuscatedString(new long[]{-1806734337800892341L, 4258236442794577695L}).toString();
    }
}

