#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.${artifactId};

import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.*;
import net.java.truelicense.json.V2JsonLicenseManagementContext;
import net.java.truelicense.obfuscate.*;

/**
 * A licensing schema for vending ${subject} license keys.
 * A licensing schema defines the algorithms and parameters for the license
 * management of the software product.
 * It also holds a license vendor manager which is configured according to this
 * definition.
 *
 * @author Christian Schlichtherle
 */
@Immutable
public final class LicensingSchema {

    /** Returns the license vendor manager. */
    public static LicenseVendorManager manager() { return Lazy.vm; }

    private static class Lazy {

        @Obfuscate
        static final String SUBJECT = "${subject}";

        @Obfuscate
        static final String PRIVATE_KEY_STORE_NAME = "private.ks";

        static final ObfuscatedString PRIVATE_KEY_STORE_PASSWORD =
                new ObfuscatedString(new long[] {
                    0x17a9e5c922dc9155l, 0xef30516fcc5e98c2l }); /* => "test1234" */

        @Obfuscate
        static final String PRIVATE_KEY_ENTRY_ALIAS = "mykey";

        static final ObfuscatedString PRIVATE_KEY_ENTRY_PASSWORD =
                new ObfuscatedString(new long[] {
                    0x149d045402a96977l, 0xa448f2162811f378l }); /* => "test1234" */

        static final ObfuscatedString PBE_PASSWORD =
                new ObfuscatedString(new long[] {
                    0xc9c00fc60c9db6b8l, 0x4a19910b12cd00c4l }); /* => "test1234" */

        static final LicenseVendorManager vm =
                new V2JsonLicenseManagementContext(SUBJECT)
                    .vendor()
                    .manager()
                        .keyStore()
                            .loadFromResource(PRIVATE_KEY_STORE_NAME)
                            .storePassword(PRIVATE_KEY_STORE_PASSWORD)
                            .alias(PRIVATE_KEY_ENTRY_ALIAS)
                            .keyPassword(PRIVATE_KEY_ENTRY_PASSWORD)
                            .inject()
                        .pbe()
                            .password(PBE_PASSWORD)
                            .inject()
                        .build();
    }
}
