#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.${artifactId};

import java.io.*;
import static java.lang.System.*;
import java.util.*;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.*;
import net.java.truelicense.core.codec.*;
import net.java.truelicense.core.io.*;
import static net.java.truelicense.obfuscate.ObfuscatedString.*;

/**
 * Creates license keys for ${subject} or obfuscates strings for configuring
 * the licensing schema.
 *
 * @author Christian Schlichtherle
 */
@Immutable
public enum Main {

    USAGE {
        @Override protected void run(final Deque<String> params) {
            throw new IllegalArgumentException();
        }
    },

    HELP {
        @Override protected void run(final Deque<String> params) {
            out.printf(valueOf(params.pop().toUpperCase(Locale.ROOT)).help());
        }
    },

    VERSION {
        @Override protected void run(final Deque<String> params) {
            out.printf(message("version"), Main.class.getSimpleName());
        }
    },

    CREATE {
        @Override protected void run(Deque<String> params) throws Exception {
            final Map<CreateOption, String>
                    o = parse(params, CreateOption.class);
            String lkp = params.poll(); // <license-key-path>
            parse(params, CreateOption.class, o);
            if (!params.isEmpty()) throw new IllegalArgumentException();
            if (null == lkp) lkp = o.get(CreateOption.KEY);
            final Store s = null != lkp
                    ? context.fileStore(new File(lkp))
                    : new MemoryStore(); // store to /dev/null
            final Codec c = parameters.codec();
            final License il;
            final String ilp = o.get(CreateOption.INPUT); // <input-license-path>
            il = null == ilp
                    ? context.license()
                    : (License) c.decode("-".equals(ilp)
                        ? Sources.input()
                        : context.fileStore(new File(ilp)),
                        License.class);
            final License ol = manager.create(il, s);
            err.println(ol);
            final String olp = o.get(CreateOption.OUTPUT); // <output-license-path>
            if (null != olp)
                c.encode("-".equals(olp)
                        ? Sinks.output()
                        : context.fileStore(new File(olp)),
                        ol);
        }
    },

    OBFUSCATE {
        @Override protected void run(final Deque<String> params) {
            final Console c = System.console();
            c.printf(message("prompt"));
            final String m = message("password");
            for (String s; 0 != (s = c.readLine(m)).length();)
                c.printf("%s\n", obfuscate(s));
        }
    };

    final LicenseVendorManager manager = LicensingSchema.manager();
    final LicenseVendorContext context = manager.context();
    final LicenseParameters parameters = manager.parameters();

    /**
     * Runs this command.
     * Implementations are free to modify the given deque.
     *
     * @param params the command parameters.
     */
    // This method needs to be protected or otherwise ProGuard 4.8 may generate
    // invalid code when --repackageclasses is set, even if
    // -allowaccessmodification is set, too.
    // See https://sourceforge.net/p/proguard/bugs/367/ for details.
    protected abstract void run(Deque<String> params) throws Exception;

    public static void main(String... args) {
        System.exit(processAndHandleExceptions(args));
    }

    @SuppressWarnings("CallToThreadDumpStack")
    static int processAndHandleExceptions(final String... args) {
        int status;
        try {
            process(args);
            status = 0;
        } catch (final IllegalArgumentException ex) {
            printUsage();
            status = 1;
        } catch (final NoSuchElementException ex) {
            printUsage();
            status = 1;
        } catch (final Throwable ex) {
            ex.printStackTrace();
            status = 2;
        }
        return status;
    }

    static void process(final String... args) throws Exception {
        final Deque<String> params = new LinkedList<String>(Arrays.asList(args));
        final String command = upperCase(params.pop());
        valueOf(command).run(params);
    }

    private static String upperCase(String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    private static void printUsage() {
        final StringBuilder builder = new StringBuilder(25 * 80);
        for (final Main main : values()) builder.append(main.usage());
        err.println(builder.toString());
    }

    String usage() {
        return String.format(message("usage"), Main.class.getSimpleName());
    }

    String help() { return message("help"); }

    String message(String key) {
        return ResourceBundle
                .getBundle(Main.class.getName())
                .getString(name() + "." + key);
    }

    /**
     * Parses the given command parameters for options of the given class with
     * a string parameter.
     * As a side effect, any found options are popped off the parameter stack.
     *
     * @param  <T> the type of the enum class for the options.
     * @param  params the command parameters.
     * @param  type the enum class for the options.
     * @return an enum map with the options and parameters found.
     */
    private static <T extends Enum<T>> EnumMap<T, String> parse(
            final Deque<String> params,
            final Class<T> type) {
        return parse(params, type, new EnumMap<T, String>(type));
    }

    private static <T extends Enum<T>, M extends Map<T, String>> M parse(
            final Deque<String> params,
            final Class<T> type,
            final M options) {
        for (   String param;
                null != (param = params.peek()) && '-' == param.charAt(0);
                ) {
            params.pop(); // consume
            param = upperCase(param.substring(1));
            options.put(valueOf(type, param), params.pop());
        }
        return options;
    }

    private enum CreateOption { KEY, INPUT, OUTPUT }
}
