#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.${artifactId};

import java.io.*;
import org.junit.*;
import org.junit.rules.*;

import static org.junit.Assert.*;
import static ${package}.${artifactId}.Main.*;

/**
 * @author Christian Schlichtherle
 */
public class MainIT {

    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testCreate() throws Exception {
        final File input = newFile("input");
        final File output = newFile("output");
        final File key = newFile("key");
        assertTrue(input.delete());
        assertTrue(output.delete());
        assertTrue(key.delete());
        final String inputPath = input.getAbsolutePath();
        final String outputPath = output.getAbsolutePath();
        final String keyPath = key.getAbsolutePath();
        process("create", "-output", inputPath, keyPath);
        process("create", "-key", keyPath, "-input", inputPath, "-output", outputPath);
        assertArrayEquals(read(input), read(output));
    }

    private File newFile(String name) throws IOException {
        return folder.newFile(name);
    }

    private static byte[] read(final File file) throws IOException {
        final byte[] data = new byte[(int) file.length()];
        final InputStream in = new FileInputStream(file);
        try { new DataInputStream(in).readFully(data); }
        finally { in.close(); }
        return data;
    }
}
