#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.${artifactId};

import java.io.*;
import java.net.*;
import org.junit.*;

import static ${package}.${artifactId}.Main.*;

/**
 * Tests the license key life cycle.
 * <p>
 * <strong>Note:</strong> If you changed the licensing schema after generating
 * this project from the TrueLicense Maven Archeype, then you need to update
 * the license key in {@code ${basedir}/src/test/resources/license.lic}, too.
 * Otherwise, these tests will fail.
 *
 * @author Christian Schlichtherle
 */
public class MainIT {

    @Test
    public void testLicenseKeyLifeCycle() throws Exception {
        process("install", resourcePath("license.lic"));
        try {
            process("view");
            process("verify");
        } finally {
            process("uninstall");
        }
    }

    private static String resourcePath(String resourceName) {
        try {
            return new File(MainIT.class
                    .getClassLoader()
                    .getResource(resourceName)
                    .toURI()).getAbsolutePath();
        } catch (URISyntaxException cannotHappen) {
            throw new AssertionError(cannotHappen);
        }
    }
}
