/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truelicense.maven.plugin.CheckedLog;
import net.java.truelicense.maven.plugin.MojoLogger;
import net.java.truelicense.maven.plugin.Scope;
import net.java.truelicense.maven.plugin.obfuscation.Processor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;

@NotThreadSafe
public abstract class ObfuscateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDirectory;
    @Parameter(property="truelicense.obfuscate.backup", defaultValue="false")
    private boolean backup;
    @Parameter(property="truelicense.obfuscate.backupPrefix", defaultValue="classes")
    private String backupPrefix;
    @Parameter(property="truelicense.obfuscate.backupExtension", defaultValue="zip")
    private String backupExtension;
    @Parameter(property="truelicense.obfuscate.maxBytes", defaultValue="65536")
    private int maxBytes;
    @Parameter(property="truelicense.obfuscate.scope", defaultValue="annotated")
    private Scope scope;
    @Parameter(property="truelicense.obfuscate.methodNameFormat", defaultValue="_%s#%d")
    private String methodNameFormat;
    @Parameter(property="truelicense.obfuscate.intern", defaultValue="true")
    private boolean intern;
    private CheckedLog checkedLog;

    public void setLog(Log log) {
        super.setLog(log);
        this.checkedLog = null;
    }

    private CheckedLog checkedLog() {
        CheckedLog checkedLog = this.checkedLog;
        return null != checkedLog ? checkedLog : (this.checkedLog = new CheckedLog(super.getLog()));
    }

    abstract TFile outputDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block10: {
            try {
                if (this.scope == Scope.none) {
                    this.checkedLog().warn("Skipping constant string value obfuscation.");
                    break block10;
                }
                this.checkedLog().info(String.format("Obfuscating %s constant string values in %s.", new Object[]{this.scope, this.outputDirectory()}));
                try {
                    try {
                        this.backup();
                        this.obfuscate();
                    }
                    finally {
                        TVFS.umount();
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new MojoExecutionException(runtimeException.toString(), (Exception)runtimeException);
                }
                catch (IOException iOException) {
                    throw new MojoFailureException(iOException.toString(), (Throwable)iOException);
                }
            }
            catch (MojoExecutionException mojoExecutionException) {
                this.checkedLog().error(mojoExecutionException.getLocalizedMessage(), mojoExecutionException);
                throw mojoExecutionException;
            }
            catch (MojoFailureException mojoFailureException) {
                this.checkedLog().error(mojoFailureException.getLocalizedMessage(), mojoFailureException);
                throw mojoFailureException;
            }
        }
        this.checkedLog().check();
    }

    private void backup() throws IOException {
        if (!this.backup) {
            return;
        }
        TFile tFile = new TFile(File.createTempFile(this.backupPrefix + ".", "." + this.backupExtension, this.buildDirectory));
        this.checkedLog().info(tFile + ": Creating class file backup directory.");
        this.outputDirectory().cp_rp((File)tFile.rm_r());
    }

    private void obfuscate() {
        new Processor((Logger)new MojoLogger(this.checkedLog()), (File)this.outputDirectory(), this.maxBytes, this.scope == Scope.all, this.methodNameFormat, this.intern).run();
    }
}

