/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin.obfuscation;

import java.io.IOException;
import net.java.truelicense.maven.plugin.obfuscation.Node;
import net.java.truelicense.maven.plugin.obfuscation.Pass;
import net.java.truelicense.maven.plugin.obfuscation.Processor;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;

final class FirstPass
extends Pass {
    private static final int CLASS_READER_FLAGS = 7;

    FirstPass(Processor processor) {
        super(processor);
    }

    @Override
    public void run() {
        Logger logger = this.logger();
        if (this.obfuscateAll()) {
            logger.debug("Skipping first pass because all constant string values should get obfuscated.");
        } else {
            logger.debug("Running first pass.");
            super.run();
        }
    }

    @Override
    void process(Node node) {
        this.logger(node).trace("Analyzing class file.");
        try {
            new ClassReader(this.read(node)).accept(this.ctx.collector(), 7);
        }
        catch (IOException iOException) {
            this.logger().error(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }
}

