/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin.obfuscation;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.maven.plugin.obfuscation.Processor;
import net.java.truelicense.maven.plugin.obfuscation.Visitor;
import net.java.truelicense.obfuscate.ObfuscatedString;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class Obfuscator
extends Visitor {
    private static final String OBFUSCATED_STRING_INTERNAL_NAME = Type.getInternalName(ObfuscatedString.class);
    private final Map<String, ConstantStringReference> csrs = new LinkedHashMap<String, ConstantStringReference>();
    private final String cmn = super.internStrings() ? "toStringIntern" : "toString";

    Obfuscator(Processor processor, ClassVisitor classVisitor) {
        super(processor, classVisitor);
    }

    @CheckForNull
    public FieldVisitor visitField(int n, String string, String string2, @CheckForNull String string3, @CheckForNull Object object) {
        return new O9n2ndFieldNode(n, string, string2, string3, object);
    }

    @CheckForNull
    public MethodVisitor visitMethod(int n, String string, String string2, @CheckForNull String string3, @CheckForNull String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
        return null == methodVisitor ? null : ("<init>".equals(string) ? new O9n2ndConstructorVisitor(string, methodVisitor) : new O9n2ndMethodVisitor(string, methodVisitor));
    }

    public void visitEnd() {
        for (Map.Entry<String, ConstantStringReference> entry : this.csrs.entrySet()) {
            this.addComputationMethod(entry.getValue());
        }
        this.cv.visitEnd();
    }

    private void addComputationMethod(ConstantStringReference constantStringReference) {
        MethodVisitor methodVisitor;
        int n = constantStringReference.access;
        boolean bl = constantStringReference.keepField();
        boolean bl2 = constantStringReference.isStatic();
        String string = constantStringReference.name;
        String string2 = constantStringReference.value;
        String string3 = ObfuscatedString.literal((String)string2);
        if (bl && bl2) {
            methodVisitor = this.cv.visitMethod(n, "<clinit>", "()V", null, null);
            if (null == methodVisitor) {
                return;
            }
            this.logger().debug("Adding method <clinit> to compute \"{}\" and put it into field {}.", (Object)string3, (Object)string);
        } else {
            methodVisitor = this.cv.visitMethod(n, string, "()Ljava/lang/String;", null, null);
            if (null == methodVisitor) {
                return;
            }
            this.logger().debug("Adding method {} to compute \"{}\".", (Object)string, (Object)string3);
        }
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, OBFUSCATED_STRING_INTERNAL_NAME);
        methodVisitor.visitInsn(89);
        long[] lArray = ObfuscatedString.array((String)string2);
        Obfuscator.addInsn(methodVisitor, lArray.length);
        methodVisitor.visitIntInsn(188, 11);
        for (int i = 0; i < lArray.length; ++i) {
            methodVisitor.visitInsn(89);
            Obfuscator.addInsn(methodVisitor, i);
            methodVisitor.visitLdcInsn((Object)lArray[i]);
            methodVisitor.visitInsn(80);
        }
        methodVisitor.visitMethodInsn(183, OBFUSCATED_STRING_INTERNAL_NAME, "<init>", "([J)V");
        methodVisitor.visitMethodInsn(182, OBFUSCATED_STRING_INTERNAL_NAME, this.cmn, "()Ljava/lang/String;");
        if (bl && bl2) {
            methodVisitor.visitFieldInsn(179, this.internalClassName(), string, "Ljava/lang/String;");
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(7, 0);
        } else {
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(7, bl2 ? 0 : 1);
        }
        methodVisitor.visitEnd();
    }

    private static void addInsn(MethodVisitor methodVisitor, int n) {
        switch (n) {
            case 0: {
                methodVisitor.visitInsn(3);
                break;
            }
            case 1: {
                methodVisitor.visitInsn(4);
                break;
            }
            case 2: {
                methodVisitor.visitInsn(5);
                break;
            }
            case 3: {
                methodVisitor.visitInsn(6);
                break;
            }
            case 4: {
                methodVisitor.visitInsn(7);
                break;
            }
            case 5: {
                methodVisitor.visitInsn(8);
                break;
            }
            default: {
                methodVisitor.visitIntInsn(16, n);
            }
        }
    }

    final ConstantStringReference register(ConstantStringReferenceFactory constantStringReferenceFactory, String string) {
        Map<String, ConstantStringReference> map = this.csrs;
        ConstantStringReference constantStringReference = map.get(string);
        if (null != constantStringReference) {
            return constantStringReference;
        }
        constantStringReference = constantStringReferenceFactory.csr(string);
        map.put(string, constantStringReference);
        return constantStringReference;
    }

    private class O9n2ndConstructorVisitor
    extends O9n2ndMethodVisitor {
        O9n2ndConstructorVisitor(String string, MethodVisitor methodVisitor) {
            super(string, methodVisitor);
        }

        @Override
        boolean readField(ConstantStringReference constantStringReference) {
            return constantStringReference.isProtectedOrPublic() && constantStringReference.isStatic();
        }
    }

    private class O9n2ndMethodVisitor
    extends MethodVisitor
    implements ConstantStringReferenceFactory {
        final String localMethodName;

        O9n2ndMethodVisitor(String string, MethodVisitor methodVisitor) {
            super(262144, methodVisitor);
            assert (null != string);
            this.localMethodName = string;
        }

        public void visitLdcInsn(Object object) {
            String string;
            if (object instanceof String && this.replace(string = (String)object)) {
                this.process(Obfuscator.this.register(this, string));
            } else {
                this.mv.visitLdcInsn(object);
            }
        }

        boolean replace(String string) {
            return Obfuscator.this.obfuscateAll() || Obfuscator.this.constantStrings().contains(string);
        }

        void process(ConstantStringReference constantStringReference) {
            boolean bl = constantStringReference.isStatic();
            String string = constantStringReference.name;
            String string2 = ObfuscatedString.literal((String)constantStringReference.value);
            String string3 = this.localMethodName;
            String string4 = Obfuscator.this.internalClassName();
            if (!bl) {
                this.mv.visitVarInsn(25, 0);
            }
            if (this.readField(constantStringReference)) {
                Obfuscator.this.logger().debug("Replacing \"{}\" in method {} with access to field {}.", new Object[]{string2, string3, string});
                int n = bl ? 178 : 180;
                this.mv.visitFieldInsn(n, string4, string, "Ljava/lang/String;");
            } else {
                Obfuscator.this.logger().debug("Replacing \"{}\" in method {} with call to method {}.", new Object[]{string2, string3, string});
                int n = bl ? 184 : (constantStringReference.isPrivate() ? 183 : 182);
                this.mv.visitMethodInsn(n, string4, string, "()Ljava/lang/String;");
            }
        }

        boolean readField(ConstantStringReference constantStringReference) {
            return constantStringReference.keepField();
        }

        @Override
        public ConstantStringReference csr(String string) {
            return new ConstantStringReference(10, Obfuscator.this.methodName("string", Obfuscator.this.csrs.size()), string);
        }
    }

    private final class O9n2ndFieldNode
    extends Visitor.O9nFieldNode
    implements ConstantStringReferenceFactory {
        O9n2ndFieldNode(int n, String string, @CheckForNull String string2, @CheckForNull String string3, Object object) {
            super(Obfuscator.this, n, string, string2, string3, object);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void visitEnd() {
            boolean bl = this.needsObfuscation;
            if (Obfuscator.this.obfuscateAll() || bl) {
                String string = this.stringValue;
                if (null != string) {
                    ConstantStringReference constantStringReference = Obfuscator.this.register(this, string);
                    String string2 = constantStringReference.name;
                    if (!constantStringReference.keepField()) {
                        Obfuscator.this.logger().debug("Removing private or package-private static field {}.", (Object)string2);
                        return;
                    }
                    if (bl) {
                        Obfuscator.this.logger().warn("Obfuscation of protected or public or non-static field {} is insecure because it can't get removed from the byte code.", (Object)string2);
                    }
                } else if (bl) {
                    Obfuscator.this.logger().error("Annotated field {} does not have a constant string value.", (Object)this.name);
                }
            }
            this.accept(Obfuscator.this.cv);
        }

        @Override
        public ConstantStringReference csr(String string) {
            return new ConstantStringReference(this.access, this.name, string);
        }
    }

    private static interface ConstantStringReferenceFactory {
        public ConstantStringReference csr(String var1);
    }

    @Immutable
    private static final class ConstantStringReference {
        final int access;
        final String name;
        final String value;

        ConstantStringReference(int n, String string, String string2) {
            this.access = n | 0x1000;
            this.name = string;
            this.value = string2;
        }

        boolean keepField() {
            return this.isProtectedOrPublic() || !this.isStatic();
        }

        boolean isPrivate() {
            return 0 != (this.access & 2);
        }

        boolean isProtectedOrPublic() {
            return 0 != (this.access & 5);
        }

        boolean isStatic() {
            return 0 != (this.access & 8);
        }
    }
}

