/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin.obfuscation;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;
import net.java.truelicense.maven.plugin.obfuscation.Collector;
import net.java.truelicense.maven.plugin.obfuscation.FirstPass;
import net.java.truelicense.maven.plugin.obfuscation.Merger;
import net.java.truelicense.maven.plugin.obfuscation.Obfuscator;
import net.java.truelicense.maven.plugin.obfuscation.SecondPass;
import net.java.truelicense.maven.plugin.obfuscation.SubjectLogger;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;

public final class Processor
implements Runnable {
    public static final int DEFAULT_MAX_BYTES = 65536;
    public static final boolean DEFAULT_OBFUSCATE_ALL = false;
    public static final String DEFAULT_METHOD_NAME_FORMAT = "_%s#%d";
    public static final boolean DEFAULT_INTERN_STRINGS = true;
    private final Set<String> constantStrings = new HashSet<String>();
    private final Logger logger;
    private final TFile directory;
    private final int maxBytes;
    private final boolean obfuscateAll;
    private final String methodNameFormat;
    private final boolean internStrings;

    public Processor(Logger logger, File file) {
        this(logger, file, 65536, false, DEFAULT_METHOD_NAME_FORMAT, true);
    }

    public Processor(Logger logger, File file, int n, boolean bl, String string, boolean bl2) {
        this.obfuscateAll = bl;
        this.logger = logger;
        if (null == this.logger) {
            throw new NullPointerException();
        }
        this.directory = file instanceof TFile ? (TFile)file : new TFile(file);
        this.maxBytes = n;
        if (0 >= this.maxBytes) {
            throw new IllegalArgumentException();
        }
        this.methodNameFormat = string;
        if (null == this.methodNameFormat) {
            throw new NullPointerException();
        }
        this.internStrings = bl2;
    }

    public Logger logger() {
        return this.logger;
    }

    public File directory() {
        return this.directory;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public boolean obfuscateAll() {
        return this.obfuscateAll;
    }

    public String methodNameFormat() {
        return this.methodNameFormat;
    }

    public boolean internStrings() {
        return this.internStrings;
    }

    Set<String> constantStrings() {
        return this.constantStrings;
    }

    Logger logger(String string) {
        return new SubjectLogger(this.logger(), string);
    }

    String methodName(String string, int n) {
        return new Formatter().format(this.methodNameFormat(), string, n).toString();
    }

    @Override
    public void run() {
        this.firstPass().run();
        this.secondPass().run();
    }

    Runnable firstPass() {
        return new FirstPass(this);
    }

    Runnable secondPass() {
        return new SecondPass(this);
    }

    ClassVisitor collector() {
        return new Collector(this);
    }

    ClassVisitor obfuscator(ClassVisitor classVisitor) {
        return new Obfuscator(this, classVisitor);
    }

    ClassVisitor merger(ClassVisitor classVisitor, String string) {
        return new Merger(this, string, classVisitor);
    }
}

