/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin.obfuscation;

import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truelicense.maven.plugin.obfuscation.Processor;
import net.java.truelicense.obfuscate.Obfuscate;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import org.slf4j.Logger;

@NotThreadSafe
abstract class Visitor
extends ClassVisitor {
    private static final String OBFUSCATE_DESCRIPTOR = Type.getDescriptor(Obfuscate.class);
    private final Processor ctx;
    private int caf;
    @Nullable
    private String icn;
    @Nullable
    private String bcn;

    Visitor(Processor processor, @CheckForNull ClassVisitor classVisitor) {
        super(262144, classVisitor);
        assert (null != processor);
        this.ctx = processor;
    }

    final Logger logger() {
        return this.ctx.logger(this.binaryClassName());
    }

    final boolean obfuscateAll() {
        return this.ctx.obfuscateAll();
    }

    final boolean internStrings() {
        return this.ctx.internStrings();
    }

    final String methodName(String string, int n) {
        return this.ctx.methodName(string, n);
    }

    final Set<String> constantStrings() {
        return this.ctx.constantStrings();
    }

    public final void visit(int n, int n2, String string, @CheckForNull String string2, @CheckForNull String string3, @CheckForNull String[] stringArray) {
        this.icn = string;
        this.bcn = Type.getObjectType((String)this.icn).getClassName();
        this.caf = n2;
        super.visit(n, this.caf, string, string2, string3, stringArray);
    }

    final boolean isInterface() {
        return 0 != (this.classAccessFlags() & 0x200);
    }

    final int classAccessFlags() {
        assert (null != this.icn) : "Illegal state.";
        return this.caf;
    }

    final String internalClassName() {
        assert (null != this.icn) : "Illegal state.";
        return this.icn;
    }

    final String binaryClassName() {
        assert (null != this.bcn) : "Illegal state.";
        return this.bcn;
    }

    class O9nFieldNode
    extends FieldNode {
        boolean needsObfuscation;
        @CheckForNull
        String stringValue;

        O9nFieldNode(int n, String string, @CheckForNull String string2, @CheckForNull String string3, Object object) {
            super(262144, n, string, string2, string3, object);
            if (object instanceof String) {
                String string4;
                this.stringValue = string4 = (String)object;
                if (Visitor.this.constantStrings().contains(string4)) {
                    this.needsObfuscation = true;
                    this.value = null;
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            if (OBFUSCATE_DESCRIPTOR.equals(string)) {
                this.needsObfuscation = true;
                if (this.value instanceof String) {
                    this.value = null;
                }
                return null;
            }
            return super.visitAnnotation(string, bl);
        }
    }
}

