/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.obfuscate;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ObfuscatedString {
    private static final Charset charset = Charset.forName(new String(new char[]{'U', 'T', 'F', '8'}));
    private final long[] obfuscated;

    public static String obfuscate(String string) {
        return ObfuscatedString.java(ObfuscatedString.array(string));
    }

    public static String java(long[] lArray) {
        StringBuilder stringBuilder = new StringBuilder(new ObfuscatedString(new long[]{-4323501854921420357L, -7292459618829599123L, -7499857796070523943L, -8049824683179062976L, 8987738347284293666L, -1372952950923297947L, -2083364859405645330L, -6442573252622261973L, 1691025859471358369L, -3528060209489739118L}).toString());
        ObfuscatedString.appendHexLiteral(stringBuilder, lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            ObfuscatedString.appendHexLiteral(stringBuilder.append(", "), lArray[i]);
        }
        return stringBuilder.append(new ObfuscatedString(new long[]{2910998555863773075L, 1429164827756647525L, -4152826516362025044L, -3839133752715642778L}).toString()).append(ObfuscatedString.literal(new ObfuscatedString(lArray).toString())).append(new ObfuscatedString(new long[]{8142799464717172459L, -6272028494055612260L}).toString()).toString();
    }

    public static String literal(String string) {
        return '\"' + string.replace("\\", new ObfuscatedString(new long[]{2476580645517518282L, 3948223014842459840L}).toString()).replace("\"", new ObfuscatedString(new long[]{2667804693087334237L, -4665391984565324909L}).toString()) + '\"';
    }

    public static long[] array(String string) {
        if (-1 != string.indexOf(0)) {
            throw new IllegalArgumentException(new ObfuscatedString(new long[]{8039990904073169097L, -5338819179594055786L, -5707383576638132258L, -7496384148344743468L, 1918303934243011853L}).toString());
        }
        byte[] byArray = string.getBytes(charset);
        int n = byArray.length;
        long[] lArray = new long[1 + (n + 7) / 8];
        long l = ObfuscatedString.key();
        Random random = new Random(l);
        lArray[0] = l;
        int n2 = 0;
        for (int i = 0; i < n; i += 8) {
            lArray[++n2] = ObfuscatedString.decode(byArray, i) ^ random.nextLong();
        }
        return lArray;
    }

    private static long key() {
        long l;
        Random random = new Random();
        while (0L == (l = random.nextLong())) {
        }
        return l;
    }

    private static void appendHexLiteral(StringBuilder stringBuilder, long l) {
        stringBuilder.append('0').append('x').append(Long.toHexString(l)).append('l');
    }

    private static long decode(byte[] byArray, int n) {
        int n2 = Math.min(byArray.length, n + 8);
        long l = 0L;
        int n3 = n2;
        while (--n3 >= n) {
            l <<= 8;
            l |= (long)(byArray[n3] & 0xFF);
        }
        return l;
    }

    private static void encode(long l, byte[] byArray, int n) {
        int n2 = Math.min(byArray.length, n + 8);
        for (int i = n; i < n2; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
    }

    public ObfuscatedString(long[] lArray) {
        this.obfuscated = (long[])lArray.clone();
        this.obfuscated[0] = lArray[0];
    }

    public char[] toCharArray() {
        return (char[])new Codec<char[]>(){

            @Override
            char[] decode(byte[] byArray, int n) throws Exception {
                return charset.newDecoder().decode(ByteBuffer.wrap(byArray, 0, n)).array();
            }
        }.call();
    }

    public String toString() {
        return (String)new Codec<String>(){

            @Override
            String decode(byte[] byArray, int n) throws Exception {
                return new String(byArray, 0, n, charset);
            }
        }.call();
    }

    public String toStringIntern() {
        return this.toString().intern();
    }

    private abstract class Codec<V>
    implements Callable<V> {
        private Codec() {
        }

        @Override
        public V call() {
            int n;
            long[] lArray = ObfuscatedString.this.obfuscated;
            int n2 = lArray.length;
            byte[] byArray = new byte[8 * (n2 - 1)];
            long l = lArray[0];
            Random random = new Random(l);
            for (n = 1; n < n2; ++n) {
                ObfuscatedString.encode(lArray[n] ^ random.nextLong(), byArray, 8 * (n - 1));
            }
            int n3 = n = byArray.length;
            while (0 < n3 && 0 == byArray[--n3]) {
                n = n3;
            }
            try {
                V v = this.decode(byArray, n);
                return v;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            finally {
                Arrays.fill(byArray, 0, n, (byte)0);
            }
        }

        abstract V decode(byte[] var1, int var2) throws Exception;
    }
}

