/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.obfuscate.processor;

import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import net.java.truelicense.obfuscate.Obfuscate;
import net.java.truelicense.obfuscate.ObfuscatedString;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"net.java.truelicense.obfuscate.Obfuscate"})
@SupportedOptions(value={"net.java.truelicense.obfuscate.verbose", "net.java.truelicense.obfuscate.processor.verbose"})
public class ObfuscateProcessor
extends AbstractProcessor {
    private boolean verbose;

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Set<String> set = this.getSupportedOptions();
        Map<String, String> map = processingEnvironment.getOptions();
        this.verbose = false;
        for (String string : set) {
            this.verbose |= Boolean.parseBoolean(map.get(string));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.errorRaised() || roundEnvironment.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : set) {
            assert (((Object)typeElement.asType()).toString().equals(Obfuscate.class.getName()));
            for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                VariableElement variableElement = (VariableElement)element;
                TypeElement typeElement2 = (TypeElement)variableElement.getEnclosingElement();
                try {
                    String string = (String)variableElement.getConstantValue();
                    if (ObfuscateProcessor.keepField(variableElement)) {
                        this.warn("Obfuscation of protected or public or non-static field is insecure because it can't get removed from the byte code.", variableElement);
                    }
                    this.debug(ObfuscatedString.obfuscate(string), variableElement);
                }
                catch (RuntimeException runtimeException) {
                    this.error("Annotated field does not have a constant string value.", variableElement);
                }
            }
        }
        return true;
    }

    private static boolean keepField(Element element) {
        Set<Modifier> set = element.getModifiers();
        return set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PUBLIC) || !set.contains((Object)Modifier.STATIC);
    }

    private void debug(CharSequence charSequence, Element element) {
        if (this.verbose) {
            this.getMessager().printMessage(Diagnostic.Kind.NOTE, charSequence, element);
        }
    }

    private void warn(CharSequence charSequence, Element element) {
        this.getMessager().printMessage(Diagnostic.Kind.WARNING, charSequence, element);
    }

    private void error(CharSequence charSequence, Element element) {
        this.getMessager().printMessage(Diagnostic.Kind.ERROR, charSequence, element);
    }

    private Messager getMessager() {
        return this.processingEnv.getMessager();
    }
}

