/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseValidationException;
import net.java.truelicense.obfuscate.ObfuscatedString;
import net.java.truelicense.swing.LicensePanel;
import net.java.truelicense.swing.LicenseWizard;
import net.java.truelicense.ui.LicenseWizardMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class DisplayPanel
extends LicensePanel {
    private static final long serialVersionUID = 1L;
    private License license;
    private JTextArea consumerComponent;
    private JLabel consumerLabel;
    private JTextArea holderComponent;
    private JLabel holderLabel;
    private JScrollPane holderScrollPane;
    private JTextArea infoComponent;
    private JLabel infoLabel;
    private JScrollPane infoScrollPane;
    private JTextArea issuedComponent;
    private JLabel issuedLabel;
    private JTextArea issuerComponent;
    private JLabel issuerLabel;
    private JScrollPane issuerScrollPane;
    private JTextArea notAfterComponent;
    private JLabel notAfterLabel;
    private JTextArea notBeforeComponent;
    private JLabel notBeforeLabel;
    private JTextArea subjectComponent;
    private JLabel subjectLabel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DisplayPanel(LicenseWizard licenseWizard) {
        super(licenseWizard);
        this.initComponents();
    }

    @Override
    public void onAfterStateSwitch() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isVisible()) {
            throw new AssertionError();
        }
        try {
            this.license = this.manager().view();
            this.onLicenseChange();
            this.manager().verify();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception instanceof LicenseValidationException ? exception.getLocalizedMessage() : this.format(LicenseWizardMessage.display_failure), this.format(LicenseWizardMessage.failure_title), 0);
        }
    }

    private void onLicenseChange() {
        if (null == this.license) {
            return;
        }
        this.subjectComponent.setText(this.toString(this.license.getSubject()));
        this.holderComponent.setText(this.toString(this.license.getHolder()));
        this.issuerComponent.setText(this.toString(this.license.getIssuer()));
        this.issuedComponent.setText(this.format(this.license.getIssued()));
        this.notBeforeComponent.setText(this.format(this.license.getNotBefore()));
        this.notAfterComponent.setText(this.format(this.license.getNotAfter()));
        this.consumerComponent.setText(LicenseWizardMessage.display_consumerFormat.format(new Object[]{this.subject(), this.license.getConsumerType(), this.license.getConsumerAmount()}).toString());
        this.infoComponent.setText(this.toString(this.license.getInfo()));
    }

    private String format(Date date) {
        return DisplayPanel.format(this.subject(), date);
    }

    static String format(String string, Date date) {
        return null == date ? DisplayPanel._string#0() : LicenseWizardMessage.display_dateTimeFormat.format(new Object[]{string, date}).toString();
    }

    private void initComponents() {
        this.subjectLabel = new JLabel();
        this.subjectComponent = new JTextArea();
        this.holderLabel = new JLabel();
        this.holderScrollPane = new JScrollPane();
        this.holderComponent = new JTextArea();
        this.issuerLabel = new JLabel();
        this.issuerScrollPane = new JScrollPane();
        this.issuerComponent = new JTextArea();
        this.issuedLabel = new JLabel();
        this.issuedComponent = new JTextArea();
        this.notBeforeLabel = new JLabel();
        this.notBeforeComponent = new JTextArea();
        this.notAfterLabel = new JLabel();
        this.notAfterComponent = new JTextArea();
        this.consumerLabel = new JLabel();
        this.consumerComponent = new JTextArea();
        this.infoLabel = new JLabel();
        this.infoScrollPane = new JScrollPane();
        this.infoComponent = new JTextArea();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.format(LicenseWizardMessage.display_title)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.setName(DisplayPanel.class.getSimpleName());
        this.setLayout(new GridBagLayout());
        this.subjectLabel.setLabelFor(this.subjectComponent);
        this.subjectLabel.setText(this.format(LicenseWizardMessage.display_subject));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.subjectLabel, gridBagConstraints);
        this.subjectComponent.setEditable(false);
        this.subjectComponent.setFont(this.getFont());
        this.subjectComponent.setBorder(BorderFactory.createEtchedBorder());
        this.subjectComponent.setName(LicenseWizardMessage.display_subject.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.subjectComponent, gridBagConstraints);
        this.holderLabel.setLabelFor(this.holderComponent);
        this.holderLabel.setText(this.format(LicenseWizardMessage.display_holder));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.holderLabel, gridBagConstraints);
        this.holderScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.holderScrollPane.setHorizontalScrollBarPolicy(31);
        this.holderScrollPane.setPreferredSize(new Dimension(300, 65));
        this.holderComponent.setEditable(false);
        this.holderComponent.setFont(this.getFont());
        this.holderComponent.setLineWrap(true);
        this.holderComponent.setWrapStyleWord(true);
        this.holderComponent.setBorder(null);
        this.holderComponent.setName(LicenseWizardMessage.display_holder.name());
        this.holderScrollPane.setViewportView(this.holderComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.holderScrollPane, gridBagConstraints);
        this.issuerLabel.setLabelFor(this.issuerComponent);
        this.issuerLabel.setText(this.format(LicenseWizardMessage.display_issuer));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.issuerLabel, gridBagConstraints);
        this.issuerScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.issuerScrollPane.setHorizontalScrollBarPolicy(31);
        this.issuerScrollPane.setPreferredSize(new Dimension(300, 65));
        this.issuerComponent.setEditable(false);
        this.issuerComponent.setFont(this.getFont());
        this.issuerComponent.setLineWrap(true);
        this.issuerComponent.setWrapStyleWord(true);
        this.issuerComponent.setBorder(null);
        this.issuerComponent.setName(LicenseWizardMessage.display_issuer.name());
        this.issuerScrollPane.setViewportView(this.issuerComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.issuerScrollPane, gridBagConstraints);
        this.issuedLabel.setLabelFor(this.issuedComponent);
        this.issuedLabel.setText(this.format(LicenseWizardMessage.display_issued));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.issuedLabel, gridBagConstraints);
        this.issuedComponent.setEditable(false);
        this.issuedComponent.setFont(this.getFont());
        this.issuedComponent.setBorder(BorderFactory.createEtchedBorder());
        this.issuedComponent.setName(LicenseWizardMessage.display_issued.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.issuedComponent, gridBagConstraints);
        this.notBeforeLabel.setLabelFor(this.notBeforeComponent);
        this.notBeforeLabel.setText(this.format(LicenseWizardMessage.display_notBefore));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.notBeforeLabel, gridBagConstraints);
        this.notBeforeComponent.setEditable(false);
        this.notBeforeComponent.setFont(this.getFont());
        this.notBeforeComponent.setBorder(BorderFactory.createEtchedBorder());
        this.notBeforeComponent.setName(LicenseWizardMessage.display_notBefore.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.notBeforeComponent, gridBagConstraints);
        this.notAfterLabel.setLabelFor(this.notAfterComponent);
        this.notAfterLabel.setText(this.format(LicenseWizardMessage.display_notAfter));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.notAfterLabel, gridBagConstraints);
        this.notAfterComponent.setEditable(false);
        this.notAfterComponent.setFont(this.getFont());
        this.notAfterComponent.setBorder(BorderFactory.createEtchedBorder());
        this.notAfterComponent.setName(LicenseWizardMessage.display_notAfter.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.notAfterComponent, gridBagConstraints);
        this.consumerLabel.setLabelFor(this.consumerComponent);
        this.consumerLabel.setText(this.format(LicenseWizardMessage.display_consumer));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.consumerLabel, gridBagConstraints);
        this.consumerComponent.setEditable(false);
        this.consumerComponent.setFont(this.getFont());
        this.consumerComponent.setBorder(BorderFactory.createEtchedBorder());
        this.consumerComponent.setName(LicenseWizardMessage.display_consumer.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.consumerComponent, gridBagConstraints);
        this.infoLabel.setLabelFor(this.infoComponent);
        this.infoLabel.setText(this.format(LicenseWizardMessage.display_info));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.infoScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.infoScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoScrollPane.setPreferredSize(new Dimension(300, 65));
        this.infoComponent.setEditable(false);
        this.infoComponent.setFont(this.getFont());
        this.infoComponent.setLineWrap(true);
        this.infoComponent.setWrapStyleWord(true);
        this.infoComponent.setBorder(null);
        this.infoComponent.setName(LicenseWizardMessage.display_info.name());
        this.infoScrollPane.setViewportView(this.infoComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.infoScrollPane, gridBagConstraints);
    }

    static {
        DisplayPanel.$assertionsDisabled = !DisplayPanel.class.desiredAssertionStatus();
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{3474275832172453241L}).toString();
    }
}

