/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.io.FileStore;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.util.Message;
import net.java.truelicense.obfuscate.ObfuscatedString;
import net.java.truelicense.swing.DisablingLicenseConsumerManager;
import net.java.truelicense.swing.EnablingLicenseConsumerManager;
import net.java.truelicense.swing.LicenseWizard;
import net.java.truelicense.swing.LicenseWorkerPanel;
import net.java.truelicense.swing.util.ComponentEnabler;
import net.java.truelicense.swing.util.EnhancedButton;
import net.java.truelicense.ui.LicenseWizardMessage;
import net.java.truelicense.ui.LicenseWizardState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class InstallPanel
extends LicenseWorkerPanel {
    private static final long serialVersionUID = 1L;
    private final LicenseConsumerManager manager;
    private EnhancedButton fileButton;
    private final JTextField fileField = new JTextField();
    private JFileChooser filechooser;
    private EnhancedButton installButton;
    private JTextArea prompt;
    private JTextArea status;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InstallPanel(LicenseWizard licenseWizard) {
        super(licenseWizard);
        ComponentEnabler componentEnabler = new ComponentEnabler(){
            static final long serialVersionUID = 0L;

            @Override
            protected JButton component() {
                return InstallPanel.this.installButton;
            }
        };
        this.manager = new EnablingLicenseConsumerManager(licenseWizard.nextButtonProxy(), new DisablingLicenseConsumerManager(componentEnabler, licenseWizard.manager()));
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                InstallPanel.this.onFileFieldChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                InstallPanel.this.onFileFieldChange();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                InstallPanel.this.onFileFieldChange();
            }
        };
        this.fileField.getDocument().addDocumentListener(documentListener);
    }

    @Override
    LicenseConsumerManager manager() {
        return this.manager;
    }

    private void onFileFieldChange() {
        boolean bl = this.fileFieldContainsValidFilePath();
        this.installButton.setEnabled(bl);
        if (bl) {
            this.installButton.requestFocusInWindow();
        }
    }

    private boolean fileFieldContainsValidFilePath() {
        String string = this.fileField.getText();
        return null != string && new File(string).isFile();
    }

    private FileFilter fileFilter() {
        class Filter
        extends FileFilter {
            final String description;

            Filter() {
                this.description = LicenseWizardMessage.install_fileFilter.format(new Object[]{InstallPanel.this.subject(), InstallPanel.this.installFileExtension()}).toString();
            }

            @Override
            public String getDescription() {
                return this.description;
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || this.transform(file.getPath()).endsWith(InstallPanel.this.installFileExtension());
            }

            String transform(String string) {
                return string;
            }
        }
        if (File.separatorChar == '\\') {
            return new Filter(){
                {
                }

                @Override
                public String transform(String string) {
                    return string.toLowerCase(Locale.ROOT);
                }
            };
        }
        return new Filter();
    }

    private String installFileExtension() {
        String string = this.format(LicenseWizardMessage.install_fileExtension);
        return string.startsWith(InstallPanel._string#0()) ? string : InstallPanel._string#0() + string;
    }

    @Override
    public LicenseWizardState nextState() {
        return LicenseWizardState.display;
    }

    @Override
    public void onAfterStateSwitch() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isVisible()) {
            throw new AssertionError();
        }
        this.wizard().nextButtonProxy().enabled(this.licenseInstalled());
        this.setStatusMessage(EMPTY_MESSAGE);
        this.fileButton.requestFocusInWindow();
        this.onFileFieldChange();
    }

    @Override
    void setStatusMessage(Message message) {
        this.status.setText(message.toString());
    }

    @Override
    Message successMessage() {
        return LicenseWizardMessage.install_success.format(new Object[]{this.subject()});
    }

    @Override
    Message failureMessage(Throwable throwable) {
        return LicenseWizardMessage.install_failure.format(new Object[]{this.subject()});
    }

    private void initComponents() {
        this.filechooser = new JFileChooser();
        this.prompt = new JTextArea();
        this.fileButton = new EnhancedButton();
        this.installButton = new EnhancedButton();
        this.status = new JTextArea();
        this.filechooser.setFileFilter(this.fileFilter());
        this.setName(InstallPanel.class.getSimpleName());
        this.setLayout(new GridBagLayout());
        this.prompt.setEditable(false);
        this.prompt.setFont(this.getFont());
        this.prompt.setLineWrap(true);
        this.prompt.setText(this.format(LicenseWizardMessage.install_prompt));
        this.prompt.setWrapStyleWord(true);
        this.prompt.setBorder(null);
        this.prompt.setName(LicenseWizardMessage.install_prompt.name());
        this.prompt.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.prompt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fileField, gridBagConstraints);
        this.fileButton.setText(this.format(LicenseWizardMessage.install_select));
        this.fileButton.setName(LicenseWizardMessage.install_select.name());
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstallPanel.this.fileButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.fileButton, gridBagConstraints);
        this.installButton.setText(this.format(LicenseWizardMessage.install_install));
        this.installButton.setName(LicenseWizardMessage.install_install.name());
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstallPanel.this.installActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.installButton, gridBagConstraints);
        this.status.setEditable(false);
        this.status.setFont(this.getFont());
        this.status.setBorder(null);
        this.status.setName(InstallPanel._string#1());
        this.status.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.status, gridBagConstraints);
    }

    private void installActionPerformed(ActionEvent actionEvent) {
        new LicenseWorkerPanel.LicenseWorker(){
            final Source source;
            {
                this.source = new FileStore(new File(InstallPanel.this.fileField.getText()));
            }

            @Override
            protected Void doInBackground() throws Exception {
                InstallPanel.this.manager().install(this.source);
                return null;
            }

            @Override
            void showExceptionDialog(Throwable throwable) {
                super.showExceptionDialog(throwable);
                InstallPanel.this.fileButton.requestFocusInWindow();
            }
        }.execute();
    }

    private void fileButtonActionPerformed(ActionEvent actionEvent) {
        if (this.filechooser.showOpenDialog(this) == 0) {
            this.fileField.setText(this.filechooser.getSelectedFile().getPath());
        }
    }

    static {
        InstallPanel.$assertionsDisabled = !InstallPanel.class.desiredAssertionStatus();
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{252418549007564640L, -4088670124705875994L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{-9030110295057117365L, -6463448647147174056L}).toString();
    }
}

