/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing;

import java.awt.Dialog;
import java.awt.Frame;
import javax.annotation.CheckForNull;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.swing.DisplayPanel;
import net.java.truelicense.swing.InstallPanel;
import net.java.truelicense.swing.LicensePanel;
import net.java.truelicense.swing.UninstallPanel;
import net.java.truelicense.swing.WelcomePanel;
import net.java.truelicense.swing.util.ComponentEnabler;
import net.java.truelicense.swing.util.EnhancedDialog;
import net.java.truelicense.swing.wizard.SwingWizardController;
import net.java.truelicense.ui.LicenseWizardMessage;
import net.java.truelicense.ui.LicenseWizardState;
import net.java.truelicense.ui.wizard.BasicWizardModel;
import net.java.truelicense.ui.wizard.WizardModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LicenseWizard {
    public static final int FINISH_RETURN_CODE;
    public static final int CANCEL_RETURN_CODE;
    private final LicenseWizardController controller;
    private final LicenseConsumerManager manager;

    public LicenseWizard(LicenseConsumerManager licenseConsumerManager) {
        this(licenseConsumerManager, (Frame)null);
    }

    public LicenseWizard(LicenseConsumerManager licenseConsumerManager, @CheckForNull Dialog dialog) {
        this(new EnhancedDialog(dialog), licenseConsumerManager);
    }

    public LicenseWizard(LicenseConsumerManager licenseConsumerManager, @CheckForNull Frame frame) {
        this(new EnhancedDialog(frame), licenseConsumerManager);
    }

    private LicenseWizard(EnhancedDialog enhancedDialog, LicenseConsumerManager licenseConsumerManager) {
        enhancedDialog.setTitle(LicenseWizardMessage.wizard_title.format(new Object[]{licenseConsumerManager.subject()}).toString());
        this.manager = licenseConsumerManager;
        this.controller = new LicenseWizardController(enhancedDialog);
        this.controller.setupPanels(this);
    }

    void enableNextButton() {
        this.nextButtonProxy().enable();
    }

    void disableNextButton() {
        this.nextButtonProxy().disable();
    }

    ComponentEnabler nextButtonProxy() {
        return this.controller.nextButtonProxy();
    }

    LicenseConsumerManager manager() {
        return this.manager;
    }

    public boolean isUninstallButtonVisible() {
        return this.controller.isUninstallButtonVisible();
    }

    public void setUninstallButtonVisible(boolean bl) {
        this.controller.setUninstallButtonVisible(bl);
    }

    public int showModalDialog() {
        return this.controller.showModalDialog().ordinal();
    }

    public int getReturnCode() {
        return this.controller.lastReturnCode().ordinal();
    }

    private static /* synthetic */ void _clinit@1396987175070#0() {
        FINISH_RETURN_CODE = SwingWizardController.ReturnCode.finish.ordinal();
        CANCEL_RETURN_CODE = SwingWizardController.ReturnCode.cancel.ordinal();
    }

    static {
        LicenseWizard._clinit@1396987175070#0();
    }

    private static final class LicenseWizardController
    extends SwingWizardController<LicenseWizardState, LicensePanel> {
        private final WizardModel<LicenseWizardState, LicensePanel> model = BasicWizardModel.create(LicenseWizardState.class);

        LicenseWizardController(EnhancedDialog enhancedDialog) {
            super(enhancedDialog);
        }

        protected WizardModel<LicenseWizardState, LicensePanel> model() {
            return this.model;
        }

        @Override
        protected ComponentEnabler nextButtonProxy() {
            return super.nextButtonProxy();
        }

        void setupPanels(LicenseWizard licenseWizard) {
            this.view(LicenseWizardState.welcome, new WelcomePanel(licenseWizard));
            this.view(LicenseWizardState.install, new InstallPanel(licenseWizard));
            this.view(LicenseWizardState.display, new DisplayPanel(licenseWizard));
            this.view(LicenseWizardState.uninstall, new UninstallPanel(licenseWizard));
        }

        boolean isUninstallButtonVisible() {
            return this.welcomePanel().isUninstallButtonVisible();
        }

        void setUninstallButtonVisible(boolean bl) {
            this.welcomePanel().setUninstallButtonVisible(bl);
        }

        private WelcomePanel welcomePanel() {
            return (WelcomePanel)super.view((Object)LicenseWizardState.welcome);
        }
    }
}

