/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.ui.util;

import java.io.Serializable;
import net.java.truelicense.obfuscate.ObfuscatedString;

public final class MnemonicText
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final int mnemonicIndex;
    private final char mnemonic;
    private final boolean isHtmlText;

    public MnemonicText(String string) {
        int n = -1;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '&') {
                if (++i >= n2) break;
                c2 = string.charAt(i);
                if (c2 != '&' && n == -1) {
                    c = c2;
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(c2);
        }
        this.text = stringBuffer.length() == n2 ? string : stringBuffer.toString();
        this.mnemonicIndex = n;
        this.mnemonic = c;
        String string2 = string.trim();
        this.isHtmlText = string2.substring(0, Math.min(MnemonicText.HTML_TAG().length(), string2.length())).equalsIgnoreCase(MnemonicText.HTML_TAG());
    }

    public String toString() {
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    public boolean isHtmlText() {
        return this.isHtmlText;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public char getMnemonic() {
        if (0 > this.mnemonicIndex) {
            throw new IllegalStateException();
        }
        return this.mnemonic;
    }

    private static final /* synthetic */ String HTML_TAG() {
        return new ObfuscatedString(new long[]{4648256364237976166L, -3654282358045603387L}).toString();
    }
}

