/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockingTaskExecutor
implements LockingTaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLockingTaskExecutor.class);
    private final LockProvider lockProvider;

    public DefaultLockingTaskExecutor(LockProvider lockProvider) {
        this.lockProvider = Objects.requireNonNull(lockProvider);
    }

    @Override
    public void executeWithLock(Runnable task, LockConfiguration lockConfig) {
        try {
            this.executeWithLock(task::run, lockConfig);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeWithLock(LockingTaskExecutor.Task task, LockConfiguration lockConfig) throws Throwable {
        Optional<SimpleLock> lock = this.lockProvider.lock(lockConfig);
        if (lock.isPresent()) {
            try {
                logger.debug("Locked '{}', lock will be held at most until {}", (Object)lockConfig.getName(), (Object)lockConfig.getLockAtMostUntil());
                task.call();
            }
            finally {
                lock.get().unlock();
                if (logger.isDebugEnabled()) {
                    Instant now;
                    Instant lockAtLeastUntil = lockConfig.getLockAtLeastUntil();
                    if (lockAtLeastUntil.isAfter(now = Instant.now())) {
                        logger.debug("Task finished, lock '{}' will be released at {}", (Object)lockConfig.getName(), (Object)lockAtLeastUntil);
                    } else {
                        logger.debug("Task finished, lock '{}' released", (Object)lockConfig.getName());
                    }
                }
            }
        } else {
            logger.debug("Not executing '{}'. It's locked.", (Object)lockConfig.getName());
        }
    }
}

