/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.util;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import net.javacrumbs.shedlock.util.SimpleLockWithConfiguration;

public class TrackingLockProviderWrapper
implements LockProvider {
    private final LockProvider wrapped;
    private final Set<SimpleLock> activeLocks = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public TrackingLockProviderWrapper(LockProvider wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        Optional<SimpleLock> result = this.wrapped.lock(lockConfiguration);
        if (result.isPresent()) {
            SimpleLockWrapper wrappedLock = new SimpleLockWrapper(result.get(), lockConfiguration);
            this.activeLocks.add(wrappedLock);
            return Optional.of(wrappedLock);
        }
        return Optional.empty();
    }

    public Collection<SimpleLock> getActiveLocks() {
        return Collections.unmodifiableSet(this.activeLocks);
    }

    private class SimpleLockWrapper
    implements SimpleLockWithConfiguration {
        private final SimpleLock wrappedLock;
        private final LockConfiguration lockConfiguration;
        private final AtomicBoolean locked = new AtomicBoolean(true);

        private SimpleLockWrapper(SimpleLock wrappedLock, LockConfiguration lockConfiguration) {
            this.wrappedLock = wrappedLock;
            this.lockConfiguration = lockConfiguration;
        }

        @Override
        public void unlock() {
            try {
                if (this.locked.compareAndSet(true, false)) {
                    this.wrappedLock.unlock();
                }
            }
            finally {
                TrackingLockProviderWrapper.this.activeLocks.remove(this);
            }
        }

        @Override
        @NonNull
        public Optional<SimpleLock> extend(@NonNull Duration lockAtMostFor, @NonNull Duration lockAtLeastFor) {
            return this.wrappedLock.extend(lockAtMostFor, lockAtLeastFor);
        }

        @Override
        public LockConfiguration getLockConfiguration() {
            return this.lockConfiguration;
        }
    }
}

