/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.HashMap;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class PostgresSqlServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "timezone('utc', CURRENT_TIMESTAMP)";
    private static final String lockAtMostFor = "timezone('utc', CURRENT_TIMESTAMP) + cast(:lockAtMostForInterval as interval)";

    PostgresSqlServerTimeStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        super(configuration);
    }

    @Override
    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, " + lockAtMostFor + ", " + now + ", :lockedBy) ON CONFLICT (" + this.name() + ") DO UPDATE" + this.updateClause();
    }

    @NonNull
    private String updateClause() {
        return " SET " + this.lockUntil() + " = " + lockAtMostFor + ", " + this.lockedAt() + " = " + now + ", " + this.lockedBy() + " = :lockedBy WHERE " + this.tableName() + "." + this.name() + " = :name AND " + this.tableName() + "." + this.lockUntil() + " <= " + now;
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + this.updateClause();
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = this.lockedAt() + " + cast(:lockAtLeastForInterval as interval)";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > " + now + " THEN " + lockAtLeastFor + " ELSE " + now + " END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + lockAtMostFor + " WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > " + now;
    }

    @Override
    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", lockConfiguration.getName());
        params.put("lockedBy", this.configuration.getLockedByValue());
        params.put("lockAtMostForInterval", lockConfiguration.getLockAtMostFor().toMillis() + " milliseconds");
        params.put("lockAtLeastForInterval", lockConfiguration.getLockAtLeastFor().toMillis() + " milliseconds");
        return params;
    }
}

