/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.Db2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.H2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.HsqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.MsSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.MySqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.OracleServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlStatementsSource {
    protected final JdbcTemplateLockProvider.Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(SqlStatementsSource.class);
    private static final String POSTGRESQL = "postgresql";
    private static final String MSSQL = "microsoft sql server";
    private static final String ORACLE = "oracle";
    private static final String MYSQL = "mysql";
    private static final String MARIADB = "mariadb";
    private static final String HSQL = "hsql database engine";
    private static final String H2 = "h2";

    SqlStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        this.configuration = configuration;
    }

    static SqlStatementsSource create(JdbcTemplateLockProvider.Configuration configuration) {
        String databaseProductName = SqlStatementsSource.getDatabaseProductName(configuration).toLowerCase();
        if (configuration.getUseDbTime()) {
            switch (databaseProductName) {
                case "postgresql": {
                    logger.debug("Using PostgresSqlServerTimeStatementsSource");
                    return new PostgresSqlServerTimeStatementsSource(configuration);
                }
                case "microsoft sql server": {
                    logger.debug("Using MsSqlServerTimeStatementsSource");
                    return new MsSqlServerTimeStatementsSource(configuration);
                }
                case "oracle": {
                    logger.debug("Using OracleServerTimeStatementsSource");
                    return new OracleServerTimeStatementsSource(configuration);
                }
                case "mysql": {
                    logger.debug("Using MySqlServerTimeStatementsSource");
                    return new MySqlServerTimeStatementsSource(configuration);
                }
                case "mariadb": {
                    logger.debug("Using MySqlServerTimeStatementsSource (for MariaDB)");
                    return new MySqlServerTimeStatementsSource(configuration);
                }
                case "hsql database engine": {
                    logger.debug("Using HsqlServerTimeStatementsSource");
                    return new HsqlServerTimeStatementsSource(configuration);
                }
                case "h2": {
                    logger.debug("Using H2ServerTimeStatementsSource");
                    return new H2ServerTimeStatementsSource(configuration);
                }
            }
            if (databaseProductName.startsWith("db2")) {
                logger.debug("Using Db2ServerTimeStatementsSource");
                return new Db2ServerTimeStatementsSource(configuration);
            }
            throw new UnsupportedOperationException("DB time is not supported for '" + databaseProductName + "'");
        }
        if (POSTGRESQL.equals(databaseProductName)) {
            logger.debug("Using PostgresSqlServerTimeStatementsSource");
            return new PostgresSqlStatementsSource(configuration);
        }
        logger.debug("Using SqlStatementsSource");
        return new SqlStatementsSource(configuration);
    }

    private static String getDatabaseProductName(JdbcTemplateLockProvider.Configuration configuration) {
        try {
            return (String)configuration.getJdbcTemplate().execute(connection -> connection.getMetaData().getDatabaseProductName());
        }
        catch (Exception e) {
            logger.debug("Can not determine database product name " + e.getMessage());
            return "Unknown";
        }
    }

    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", lockConfiguration.getName());
        params.put("lockUntil", this.timestamp(lockConfiguration.getLockAtMostUntil()));
        params.put("now", this.timestamp(ClockProvider.now()));
        params.put("lockedBy", this.configuration.getLockedByValue());
        params.put("unlockTime", this.timestamp(lockConfiguration.getUnlockTime()));
        return params;
    }

    @NonNull
    private Object timestamp(Instant time) {
        TimeZone timeZone = this.configuration.getTimeZone();
        if (timeZone == null) {
            return Timestamp.from(time);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.from(time));
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, :lockUntil, :now, :lockedBy)";
    }

    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil, " + this.lockedAt() + " = :now, " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= :now";
    }

    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > :now";
    }

    public String getUnlockStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :unlockTime WHERE " + this.name() + " = :name";
    }

    String name() {
        return this.configuration.getColumnNames().getName();
    }

    String lockUntil() {
        return this.configuration.getColumnNames().getLockUntil();
    }

    String lockedAt() {
        return this.configuration.getColumnNames().getLockedAt();
    }

    String lockedBy() {
        return this.configuration.getColumnNames().getLockedBy();
    }

    String tableName() {
        return this.configuration.getTableName();
    }
}

