/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import net.javacrumbs.shedlock.provider.jdbctemplate.Db2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.H2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.HsqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.MsSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.MySqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.OracleServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public enum DatabaseProduct {
    POSTGRES_SQL("PostgreSQL"::equalsIgnoreCase, PostgresSqlServerTimeStatementsSource::new),
    SQL_SERVER("Microsoft SQL Server"::equalsIgnoreCase, MsSqlServerTimeStatementsSource::new),
    ORACLE("Oracle"::equalsIgnoreCase, OracleServerTimeStatementsSource::new),
    MY_SQL("MySQL"::equalsIgnoreCase, MySqlServerTimeStatementsSource::new),
    MARIA_DB("MariaDB"::equalsIgnoreCase, MySqlServerTimeStatementsSource::new),
    HQL("HSQL Database Engine"::equalsIgnoreCase, HsqlServerTimeStatementsSource::new),
    H2("H2"::equalsIgnoreCase, H2ServerTimeStatementsSource::new),
    DB2(s -> s.substring(0, 3).equalsIgnoreCase("DB2"), Db2ServerTimeStatementsSource::new),
    UNKNOWN(s -> false, configuration -> {
        throw new UnsupportedOperationException("DB time is not supported for unknown database product");
    });

    private final Predicate<String> productMatcher;
    private final Function<JdbcTemplateLockProvider.Configuration, SqlStatementsSource> serverTimeStatementsSource;

    private DatabaseProduct(Predicate<String> productMatcher, Function<JdbcTemplateLockProvider.Configuration, SqlStatementsSource> serverTimeStatementsSource) {
        this.productMatcher = productMatcher;
        this.serverTimeStatementsSource = serverTimeStatementsSource;
    }

    SqlStatementsSource getDbTimeStatementSource(JdbcTemplateLockProvider.Configuration configuration) {
        return this.serverTimeStatementsSource.apply(configuration);
    }

    @NonNull
    static DatabaseProduct matchProductName(String productName) {
        return Arrays.stream(DatabaseProduct.values()).filter(databaseProduct -> databaseProduct.productMatcher.test(productName)).findFirst().orElse(UNKNOWN);
    }
}

