/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring1;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;

@Deprecated
public class RedisLockProvider
implements LockProvider {
    private static final String KEY_PREFIX_DEFAULT = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final RedisConnectionFactory redisConnectionFactory;
    private final String environment;
    private final String keyPrefix;

    public RedisLockProvider(@NonNull RedisConnectionFactory redisConn) {
        this(redisConn, ENV_DEFAULT);
    }

    public RedisLockProvider(@NonNull RedisConnectionFactory redisConn, @NonNull String environment) {
        this(redisConn, environment, KEY_PREFIX_DEFAULT);
    }

    public RedisLockProvider(@NonNull RedisConnectionFactory redisConn, @NonNull String environment, @NonNull String keyPrefix) {
        this.redisConnectionFactory = redisConn;
        this.environment = environment;
        this.keyPrefix = keyPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        RedisConnection redisConnection;
        block5: {
            byte[] maybeOldValue;
            byte[] keyBytes;
            String key;
            block4: {
                Optional<SimpleLock> optional;
                key = this.buildKey(lockConfiguration.getName());
                redisConnection = null;
                try {
                    keyBytes = RedisLockProvider.getBytes(key);
                    redisConnection = this.redisConnectionFactory.getConnection();
                    if (!redisConnection.setNX(keyBytes, RedisLockProvider.buildValue(lockConfiguration.getLockAtMostUntil())).booleanValue()) break block4;
                    optional = Optional.of(new RedisLock(key, this.redisConnectionFactory, lockConfiguration));
                }
                catch (Throwable throwable) {
                    RedisLockProvider.close(redisConnection);
                    throw throwable;
                }
                RedisLockProvider.close(redisConnection);
                return optional;
            }
            byte[] value = redisConnection.get(keyBytes);
            if (!this.isUnlocked(value) || !this.isUnlocked(maybeOldValue = redisConnection.getSet(keyBytes, RedisLockProvider.buildValue(lockConfiguration.getLockAtMostUntil())))) break block5;
            Optional<SimpleLock> optional = Optional.of(new RedisLock(key, this.redisConnectionFactory, lockConfiguration));
            RedisLockProvider.close(redisConnection);
            return optional;
        }
        Optional<SimpleLock> optional = Optional.empty();
        RedisLockProvider.close(redisConnection);
        return optional;
    }

    private static byte[] getBytes(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    private boolean isUnlocked(byte[] value) {
        return value == null || RedisLockProvider.getExpirationFromValue(value).getExpirationTimeInMilliseconds() <= 0L;
    }

    private static Expiration getExpiration(Instant until) {
        return Expiration.from((long)RedisLockProvider.getMsUntil(until), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static long getMsUntil(Instant until) {
        return Duration.between(ClockProvider.now(), until).toMillis();
    }

    private static void close(RedisConnection redisConnection) {
        if (redisConnection != null) {
            redisConnection.close();
        }
    }

    String buildKey(String lockName) {
        return String.format("%s:%s:%s", this.keyPrefix, this.environment, lockName);
    }

    private static byte[] buildValue(Instant lockAtMostUntil) {
        return RedisLockProvider.getBytes(String.format("ADDED:%s@%s EXP:%s", ClockProvider.now().toString(), Utils.getHostname(), lockAtMostUntil.toString()));
    }

    static Expiration getExpirationFromValue(byte[] value) {
        Instant expires = Instant.parse(new String(value, StandardCharsets.UTF_8).split("EXP:")[1]);
        return RedisLockProvider.getExpiration(expires);
    }

    private static final class RedisLock
    implements SimpleLock {
        private final String key;
        private final RedisConnectionFactory redisConnectionFactory;
        private final LockConfiguration lockConfiguration;

        private RedisLock(String key, RedisConnectionFactory redisConnectionFactory, LockConfiguration lockConfiguration) {
            this.key = key;
            this.redisConnectionFactory = redisConnectionFactory;
            this.lockConfiguration = lockConfiguration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            Expiration keepLockFor = RedisLockProvider.getExpiration(this.lockConfiguration.getLockAtLeastUntil());
            RedisConnection redisConnection = null;
            if (keepLockFor.getExpirationTimeInMilliseconds() <= 0L) {
                try {
                    redisConnection = this.redisConnectionFactory.getConnection();
                    redisConnection.del((byte[][])new byte[][]{RedisLockProvider.getBytes(this.key)});
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
                finally {
                    RedisLockProvider.close(redisConnection);
                }
            }
            try {
                redisConnection = this.redisConnectionFactory.getConnection();
                redisConnection.set(RedisLockProvider.getBytes(this.key), RedisLockProvider.buildValue(this.lockConfiguration.getLockAtMostUntil()), keepLockFor, RedisStringCommands.SetOption.SET_IF_PRESENT);
            }
            finally {
                RedisLockProvider.close(redisConnection);
            }
        }
    }
}

