/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class SpringLockConfigurationExtractor
implements LockConfigurationExtractor {
    static final Duration DEFAULT_LOCK_AT_MOST_FOR = Duration.of(1L, ChronoUnit.HOURS);
    private final Logger logger = LoggerFactory.getLogger(SpringLockConfigurationExtractor.class);
    private final TemporalAmount defaultLockAtMostFor;
    private final TemporalAmount defaultLockAtLeastFor;
    private final StringValueResolver embeddedValueResolver;

    @Deprecated
    public SpringLockConfigurationExtractor() {
        this(DEFAULT_LOCK_AT_MOST_FOR);
    }

    @Deprecated
    public SpringLockConfigurationExtractor(TemporalAmount defaultLockAtMostFor) {
        this(defaultLockAtMostFor, Duration.ZERO);
    }

    @Deprecated
    public SpringLockConfigurationExtractor(TemporalAmount defaultLockAtMostFor, Duration defaultLockAtLeastFor) {
        this(defaultLockAtMostFor, defaultLockAtLeastFor, null);
    }

    public SpringLockConfigurationExtractor(TemporalAmount defaultLockAtMostFor, TemporalAmount defaultLockAtLeastFor, StringValueResolver embeddedValueResolver) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public Optional<LockConfiguration> getLockConfiguration(Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            SchedulerLock annotation = this.findAnnotation((ScheduledMethodRunnable)task);
            if (this.shouldLock(annotation)) {
                Instant now = Instant.now();
                return Optional.of(new LockConfiguration(annotation.name(), now.plus(this.getLockAtMostFor(annotation)), now.plus(this.getLockAtLeastFor(annotation))));
            }
        } else {
            this.logger.debug("Unknown task type " + task);
        }
        return Optional.empty();
    }

    SchedulerLock findAnnotation(ScheduledMethodRunnable task) {
        Method method = task.getMethod();
        SchedulerLock annotation = this.findAnnotation(method);
        if (annotation != null) {
            return annotation;
        }
        Class targetClass = AopUtils.getTargetClass((Object)task.getTarget());
        if (targetClass != null && !task.getTarget().getClass().equals(targetClass)) {
            try {
                Method methodOnTarget = targetClass.getMethod(method.getName(), method.getParameterTypes());
                return this.findAnnotation(methodOnTarget);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private SchedulerLock findAnnotation(Method method) {
        return (SchedulerLock)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, SchedulerLock.class);
    }

    TemporalAmount getLockAtMostFor(SchedulerLock annotation) {
        return this.getValue(annotation.lockAtMostFor(), annotation.lockAtMostForString(), this.defaultLockAtMostFor, "lockAtMostForString");
    }

    TemporalAmount getLockAtLeastFor(SchedulerLock annotation) {
        return this.getValue(annotation.lockAtLeastFor(), annotation.lockAtLeastForString(), this.defaultLockAtLeastFor, "lockAtLeastForString");
    }

    private TemporalAmount getValue(long valueFromAnnotation, String stringValueFromAnnotation, TemporalAmount defaultValue, String paramName) {
        if (valueFromAnnotation >= 0L) {
            return Duration.of(valueFromAnnotation, ChronoUnit.MILLIS);
        }
        if (StringUtils.hasText((String)stringValueFromAnnotation)) {
            if (this.embeddedValueResolver != null) {
                stringValueFromAnnotation = this.embeddedValueResolver.resolveStringValue(stringValueFromAnnotation);
            }
            try {
                return Duration.of(Long.valueOf(stringValueFromAnnotation), ChronoUnit.MILLIS);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot parse into long");
            }
        }
        return defaultValue;
    }

    private boolean shouldLock(SchedulerLock annotation) {
        return annotation != null;
    }
}

