/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockableRunnable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public class LockableTaskScheduler
implements TaskScheduler {
    private final TaskScheduler taskScheduler;
    private final LockManager lockManager;

    public LockableTaskScheduler(TaskScheduler taskScheduler, LockManager lockManager) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.lockManager = Objects.requireNonNull(lockManager);
    }

    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.taskScheduler.schedule(this.wrap(task), trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.taskScheduler.schedule(this.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.taskScheduler.scheduleAtFixedRate(this.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.taskScheduler.scheduleAtFixedRate(this.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.taskScheduler.scheduleWithFixedDelay(this.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.taskScheduler.scheduleWithFixedDelay(this.wrap(task), delay);
    }

    private Runnable wrap(Runnable task) {
        return new LockableRunnable(task, this.lockManager);
    }
}

