/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.lang.reflect.Method;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.support.ScheduledMethodRunnable;

public class SpringLockConfigurationExtractor
implements LockConfigurationExtractor {
    private final Logger logger = LoggerFactory.getLogger(SpringLockConfigurationExtractor.class);

    public Optional<LockConfiguration> getLockConfiguration(Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            Method method = ((ScheduledMethodRunnable)task).getMethod();
            SchedulerLock annotation = (SchedulerLock)AnnotationUtils.findAnnotation((Method)method, SchedulerLock.class);
            if (this.shouldLock(annotation)) {
                return Optional.of(new LockConfiguration(annotation.name(), Instant.now().plus(annotation.lockAtMostFor(), ChronoUnit.MILLIS)));
            }
        } else {
            this.logger.debug("Unknown task type " + task);
        }
        return Optional.empty();
    }

    private boolean shouldLock(SchedulerLock annotation) {
        return annotation != null;
    }
}

