/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.util.concurrent.ScheduledExecutorService;
import net.javacrumbs.shedlock.core.DefaultLockManager;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.spring.LockableTaskScheduler;
import net.javacrumbs.shedlock.spring.SpringLockConfigurationExtractor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class SpringLockableTaskSchedulerFactory {
    public static LockableTaskScheduler newLockableTaskScheduler(TaskScheduler taskScheduler, LockProvider lockProvider) {
        return new LockableTaskScheduler(taskScheduler, (LockManager)new DefaultLockManager(lockProvider, (LockConfigurationExtractor)new SpringLockConfigurationExtractor()));
    }

    public static LockableTaskScheduler newLockableTaskScheduler(ScheduledExecutorService scheduledExecutorService, LockProvider lockProvider) {
        return SpringLockableTaskSchedulerFactory.newLockableTaskScheduler((TaskScheduler)new ConcurrentTaskScheduler(scheduledExecutorService), lockProvider);
    }

    public static LockableTaskScheduler newLockableTaskScheduler(int poolSize, LockProvider lockProvider) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(poolSize);
        taskScheduler.initialize();
        return SpringLockableTaskSchedulerFactory.newLockableTaskScheduler((TaskScheduler)taskScheduler, lockProvider);
    }
}

