/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.time.Duration;
import java.util.Map;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringValueResolver;

class AbstractSchedulerLockConfiguration
implements ImportAware,
EmbeddedValueResolverAware {
    private AnnotationAttributes annotationAttributes;
    private StringValueResolver resolver;

    AbstractSchedulerLockConfiguration() {
    }

    protected String getDefaultLockAtLeastFor() {
        return this.getStringFromAnnotation("defaultLockAtLeastFor");
    }

    protected String getDefaultLockAtMostFor() {
        return this.getStringFromAnnotation("defaultLockAtMostFor");
    }

    protected String getStringFromAnnotation(String defaultLockAtLeastFor) {
        return this.annotationAttributes.getString(defaultLockAtLeastFor);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableSchedulerLock.class.getName(), false));
        if (this.annotationAttributes == null) {
            throw new IllegalArgumentException("@EnableSchedulerLock is not present on importing class " + importMetadata.getClassName());
        }
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    protected Duration defaultLockAtLeastForDuration() {
        return this.toDuration(this.getDefaultLockAtLeastFor());
    }

    protected Duration defaultLockAtMostForDuration() {
        return this.toDuration(this.getDefaultLockAtMostFor());
    }

    protected StringValueResolver getResolver() {
        return this.resolver;
    }

    private Duration toDuration(String string) {
        return Duration.parse(this.resolver.resolveStringValue(string));
    }
}

