/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.Fake;
import net.kaczmarzyk.spring.data.jpa.domain.FakeSpecWrapper;
import org.springframework.data.jpa.domain.Specification;

public class Conjunction<T>
implements Specification<T>,
FakeSpecWrapper<T> {
    private static final long serialVersionUID = 1L;
    private Collection<Specification<T>> innerSpecs;
    private Set<CriteriaQuery<?>> queriesWithInitializedFakes = new HashSet();

    @SafeVarargs
    public Conjunction(Specification<T> ... innerSpecs) {
        this(Arrays.asList(innerSpecs));
    }

    public Conjunction(Collection<Specification<T>> innerSpecs) {
        this.innerSpecs = innerSpecs;
    }

    @Override
    public void initializeFakes(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (!this.queriesWithInitializedFakes.contains(query)) {
            for (Specification<T> spec : this.innerSpecs) {
                if (spec instanceof FakeSpecWrapper) {
                    ((FakeSpecWrapper)spec).initializeFakes(root, query, cb);
                }
                if (!(spec instanceof Fake)) continue;
                spec.toPredicate(root, query, cb);
            }
        }
        this.queriesWithInitializedFakes.add(query);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        this.initializeFakes(root, query, cb);
        return cb.and(this.innerSpecs.stream().filter(spec -> !(spec instanceof Fake)).map(spec -> spec.toPredicate(root, query, cb)).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new Predicate[0]));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.innerSpecs == null ? 0 : this.innerSpecs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conjunction other = (Conjunction)obj;
        return !(this.innerSpecs == null ? other.innerSpecs != null : !this.innerSpecs.equals(other.innerSpecs));
    }

    public String toString() {
        return "Conjunction [innerSpecs=" + this.innerSpecs + "]";
    }
}

