/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.filters.AddHeadersFilter;
import net.lightbody.bmp.filters.AutoBasicAuthFilter;
import net.lightbody.bmp.filters.BlacklistFilter;
import net.lightbody.bmp.filters.BrowserMobHttpFilterChain;
import net.lightbody.bmp.filters.HarCaptureFilter;
import net.lightbody.bmp.filters.HttpConnectHarCaptureFilter;
import net.lightbody.bmp.filters.HttpsHostCaptureFilter;
import net.lightbody.bmp.filters.HttpsOriginalHostCaptureFilter;
import net.lightbody.bmp.filters.LatencyFilter;
import net.lightbody.bmp.filters.RegisterRequestFilter;
import net.lightbody.bmp.filters.RequestFilter;
import net.lightbody.bmp.filters.RequestFilterAdapter;
import net.lightbody.bmp.filters.ResolvedHostnameCacheFilter;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.filters.ResponseFilterAdapter;
import net.lightbody.bmp.filters.RewriteUrlFilter;
import net.lightbody.bmp.filters.UnregisterRequestFilter;
import net.lightbody.bmp.filters.WhitelistFilter;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import net.lightbody.bmp.mitm.KeyStoreFileCertificateSource;
import net.lightbody.bmp.mitm.TrustSource;
import net.lightbody.bmp.mitm.keys.ECKeyGenerator;
import net.lightbody.bmp.mitm.keys.KeyGenerator;
import net.lightbody.bmp.mitm.keys.RSAKeyGenerator;
import net.lightbody.bmp.mitm.manager.ImpersonatingMitmManager;
import net.lightbody.bmp.proxy.ActivityMonitor;
import net.lightbody.bmp.proxy.BlacklistEntry;
import net.lightbody.bmp.proxy.CaptureType;
import net.lightbody.bmp.proxy.RewriteRule;
import net.lightbody.bmp.proxy.Whitelist;
import net.lightbody.bmp.proxy.auth.AuthType;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;
import net.lightbody.bmp.proxy.dns.DelegatingHostResolver;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import net.lightbody.bmp.util.BrowserMobProxyUtil;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HostResolver;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.littleshoot.proxy.impl.ThreadPoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobProxyServer
implements BrowserMobProxy {
    private static final Logger log = LoggerFactory.getLogger(BrowserMobProxyServer.class);
    private static final HarNameVersion HAR_CREATOR_VERSION = new HarNameVersion("BrowserMob Proxy", BrowserMobProxyUtil.getVersionString());
    private static final String RSA_KEYSTORE_RESOURCE = "/sslSupport/ca-keystore-rsa.p12";
    private static final String EC_KEYSTORE_RESOURCE = "/sslSupport/ca-keystore-ec.p12";
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String KEYSTORE_PRIVATE_KEY_ALIAS = "key";
    private static final String KEYSTORE_PASSWORD = "password";
    public static final String VIA_HEADER_ALIAS = "browsermobproxy";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger harPageCount = new AtomicInteger(0);
    private volatile boolean mitmDisabled = false;
    private volatile MitmManager mitmManager;
    private final List<HttpFiltersSource> filterFactories = new CopyOnWriteArrayList<HttpFiltersSource>();
    private volatile Collection<BlacklistEntry> blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>();
    private volatile CopyOnWriteArrayList<RewriteRule> rewriteRules = new CopyOnWriteArrayList();
    private volatile HttpProxyServer proxyServer;
    private volatile EnumSet<CaptureType> harCaptureTypes = EnumSet.noneOf(CaptureType.class);
    private volatile Har har;
    private volatile HarPage currentHarPage;
    private volatile long readBandwidthLimitBps;
    private volatile long writeBandwidthLimitBps;
    private final AtomicReference<Whitelist> whitelist = new AtomicReference<Whitelist>(Whitelist.WHITELIST_DISABLED);
    private volatile ConcurrentMap<String, String> additionalHeaders = new MapMaker().concurrencyLevel(1).makeMap();
    private volatile int connectTimeoutMs;
    private volatile int idleConnectionTimeoutSec;
    private volatile int latencyMs;
    private final AtomicBoolean harCaptureFilterEnabled = new AtomicBoolean(false);
    private volatile InetSocketAddress upstreamProxyAddress;
    private volatile ChainedProxyManager chainedProxyManager;
    private volatile InetAddress serverBindAddress;
    private volatile TrustSource trustSource = TrustSource.defaultTrustSource();
    private volatile boolean useEcc = false;
    private final DelegatingHostResolver delegatingResolver = new DelegatingHostResolver(ClientUtil.createNativeCacheManipulatingResolver());
    private final ActivityMonitor activityMonitor = new ActivityMonitor();
    private volatile ThreadPoolConfiguration threadPoolConfiguration;
    private final ConcurrentMap<String, String> basicAuthCredentials = new MapMaker().concurrencyLevel(1).makeMap();
    private volatile String chainedProxyCredentials;

    @Override
    public void start(int port, InetAddress clientBindAddress, InetAddress serverBindAddress) {
        boolean notStarted = this.started.compareAndSet(false, true);
        if (!notStarted) {
            throw new IllegalStateException("Proxy server is already started. Not restarting.");
        }
        InetSocketAddress clientBindSocket = clientBindAddress == null ? new InetSocketAddress(port) : new InetSocketAddress(clientBindAddress, port);
        this.serverBindAddress = serverBindAddress;
        this.addBrowserMobFilters();
        HttpProxyServerBootstrap bootstrap = DefaultHttpProxyServer.bootstrap().withFiltersSource(new HttpFiltersSource(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext channelHandlerContext) {
                return new BrowserMobHttpFilterChain(BrowserMobProxyServer.this, originalRequest, channelHandlerContext);
            }

            public int getMaximumRequestBufferSizeInBytes() {
                return BrowserMobProxyServer.this.getMaximumRequestBufferSize();
            }

            public int getMaximumResponseBufferSizeInBytes() {
                return BrowserMobProxyServer.this.getMaximumResponseBufferSize();
            }
        }).withServerResolver((HostResolver)this.delegatingResolver).withAddress(clientBindSocket).withConnectTimeout(this.connectTimeoutMs).withIdleConnectionTimeout(this.idleConnectionTimeoutSec).withProxyAlias(VIA_HEADER_ALIAS);
        if (serverBindAddress != null) {
            bootstrap.withNetworkInterface(new InetSocketAddress(serverBindAddress, 0));
        }
        if (!this.mitmDisabled) {
            if (this.mitmManager == null) {
                this.mitmManager = ImpersonatingMitmManager.builder().rootCertificateSource((CertificateAndKeySource)new KeyStoreFileCertificateSource(KEYSTORE_TYPE, this.useEcc ? EC_KEYSTORE_RESOURCE : RSA_KEYSTORE_RESOURCE, KEYSTORE_PRIVATE_KEY_ALIAS, KEYSTORE_PASSWORD)).serverKeyGenerator((KeyGenerator)(this.useEcc ? new ECKeyGenerator() : new RSAKeyGenerator())).trustSource(this.trustSource).build();
            }
            bootstrap.withManInTheMiddle(this.mitmManager);
        }
        if (this.readBandwidthLimitBps > 0L || this.writeBandwidthLimitBps > 0L) {
            bootstrap.withThrottling(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
        if (this.chainedProxyManager != null) {
            bootstrap.withChainProxyManager(this.chainedProxyManager);
        } else if (this.upstreamProxyAddress != null) {
            bootstrap.withChainProxyManager(new ChainedProxyManager(){

                public void lookupChainedProxies(HttpRequest httpRequest, Queue<ChainedProxy> chainedProxies) {
                    final InetSocketAddress upstreamProxy = BrowserMobProxyServer.this.upstreamProxyAddress;
                    if (upstreamProxy != null) {
                        chainedProxies.add((ChainedProxy)new ChainedProxyAdapter(){

                            public InetSocketAddress getChainedProxyAddress() {
                                return upstreamProxy;
                            }

                            public void filterRequest(HttpObject httpObject) {
                                String chainedProxyAuth = BrowserMobProxyServer.this.chainedProxyCredentials;
                                if (chainedProxyAuth != null && httpObject instanceof HttpRequest) {
                                    HttpHeaders.addHeader((HttpMessage)((HttpRequest)httpObject), (String)"Proxy-Authorization", (Object)("Basic " + chainedProxyAuth));
                                }
                            }
                        });
                    }
                }
            });
        }
        if (this.threadPoolConfiguration != null) {
            bootstrap.withThreadPoolConfiguration(this.threadPoolConfiguration);
        }
        this.proxyServer = bootstrap.start();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public void start(int port) {
        this.start(port, null, null);
    }

    @Override
    public void start(int port, InetAddress bindAddress) {
        this.start(port, bindAddress, null);
    }

    @Override
    public void start() {
        this.start(0);
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    @Override
    public void abort() {
        this.stop(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void stop(boolean graceful) {
        if (!this.isStarted()) throw new IllegalStateException("Proxy server has not been started");
        if (!this.stopped.compareAndSet(false, true)) throw new IllegalStateException("Proxy server is already stopped. Cannot re-stop.");
        if (this.proxyServer != null) {
            if (graceful) {
                this.proxyServer.stop();
                return;
            } else {
                this.proxyServer.abort();
            }
            return;
        } else {
            log.warn("Attempted to stop proxy server, but proxy was never successfully started.");
        }
    }

    @Override
    public InetAddress getClientBindAddress() {
        if (this.started.get()) {
            return this.proxyServer.getListenAddress().getAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.started.get()) {
            return this.proxyServer.getListenAddress().getPort();
        }
        return 0;
    }

    @Override
    public InetAddress getServerBindAddress() {
        return this.serverBindAddress;
    }

    @Override
    public Har getHar() {
        return this.har;
    }

    @Override
    public Har newHar() {
        return this.newHar(null);
    }

    @Override
    public Har newHar(String initialPageRef) {
        return this.newHar(initialPageRef, null);
    }

    @Override
    public Har newHar(String initialPageRef, String initialPageTitle) {
        BrowserMobProxyUtil.getUserAgentStringParser();
        Har oldHar = this.getHar();
        this.addHarCaptureFilter();
        this.harPageCount.set(0);
        this.har = new Har(new HarLog(HAR_CREATOR_VERSION));
        this.newPage(initialPageRef, initialPageTitle);
        return oldHar;
    }

    @Override
    public void setHarCaptureTypes(Set<CaptureType> harCaptureSettings) {
        this.harCaptureTypes = harCaptureSettings == null || harCaptureSettings.isEmpty() ? EnumSet.noneOf(CaptureType.class) : EnumSet.copyOf(harCaptureSettings);
    }

    @Override
    public void setHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.setHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.setHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    @Override
    public EnumSet<CaptureType> getHarCaptureTypes() {
        return EnumSet.copyOf(this.harCaptureTypes);
    }

    @Override
    public void enableHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.harCaptureTypes.addAll(captureTypes);
    }

    @Override
    public void enableHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.enableHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.enableHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    @Override
    public void disableHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.harCaptureTypes.removeAll(captureTypes);
    }

    @Override
    public void disableHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.disableHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.disableHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    @Override
    public Har newPage() {
        return this.newPage(null);
    }

    @Override
    public Har newPage(String pageRef) {
        return this.newPage(pageRef, null);
    }

    @Override
    public Har newPage(String pageRef, String pageTitle) {
        if (this.har == null) {
            throw new IllegalStateException("No HAR exists for this proxy. Use newHar() to create a new HAR before calling newPage().");
        }
        Har endOfPageHar = null;
        if (this.currentHarPage != null) {
            String currentPageRef = this.currentHarPage.getId();
            this.endPage();
            endOfPageHar = BrowserMobProxyUtil.copyHarThroughPageRef(this.har, currentPageRef);
        }
        if (pageRef == null) {
            pageRef = "Page " + this.harPageCount.getAndIncrement();
        }
        if (pageTitle == null) {
            pageTitle = pageRef;
        }
        HarPage newPage = new HarPage(pageRef, pageTitle);
        this.har.getLog().addPage(newPage);
        this.currentHarPage = newPage;
        return endOfPageHar;
    }

    @Override
    public Har endHar() {
        Har oldHar = this.getHar();
        this.endPage();
        this.har = null;
        return oldHar;
    }

    @Override
    public void setReadBandwidthLimit(long bytesPerSecond) {
        this.readBandwidthLimitBps = bytesPerSecond;
        if (this.isStarted()) {
            this.proxyServer.setThrottle(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
    }

    @Override
    public long getReadBandwidthLimit() {
        return this.readBandwidthLimitBps;
    }

    @Override
    public void setWriteBandwidthLimit(long bytesPerSecond) {
        this.writeBandwidthLimitBps = bytesPerSecond;
        if (this.isStarted()) {
            this.proxyServer.setThrottle(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
    }

    @Override
    public long getWriteBandwidthLimit() {
        return this.writeBandwidthLimitBps;
    }

    public void endPage() {
        if (this.har == null) {
            throw new IllegalStateException("No HAR exists for this proxy. Use newHar() to create a new HAR.");
        }
        HarPage previousPage = this.currentHarPage;
        this.currentHarPage = null;
        if (previousPage == null) {
            return;
        }
        previousPage.getPageTimings().setOnLoad(new Date().getTime() - previousPage.getStartedDateTime().getTime());
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        ConcurrentMap newHeaders = new MapMaker().concurrencyLevel(1).makeMap();
        newHeaders.putAll(headers);
        this.additionalHeaders = newHeaders;
    }

    @Override
    public void setLatency(long latency, TimeUnit timeUnit) {
        this.latencyMs = (int)TimeUnit.MILLISECONDS.convert(latency, timeUnit);
    }

    @Override
    public void autoAuthorization(String domain, String username, String password, AuthType authType) {
        switch (authType) {
            case BASIC: {
                String base64EncodedCredentials = BrowserMobHttpUtil.base64EncodeBasicCredentials(username, password);
                this.basicAuthCredentials.put(domain, base64EncodedCredentials);
                break;
            }
            default: {
                throw new UnsupportedOperationException("AuthType " + (Object)((Object)authType) + " is not supported for HTTP Authorization");
            }
        }
    }

    @Override
    public void stopAutoAuthorization(String domain) {
        this.basicAuthCredentials.remove(domain);
    }

    @Override
    public void chainedProxyAuthorization(String username, String password, AuthType authType) {
        switch (authType) {
            case BASIC: {
                this.chainedProxyCredentials = BrowserMobHttpUtil.base64EncodeBasicCredentials(username, password);
                break;
            }
            default: {
                throw new UnsupportedOperationException("AuthType " + (Object)((Object)authType) + " is not supported for Proxy Authorization");
            }
        }
    }

    @Override
    public void setConnectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(connectTimeout, timeUnit);
        if (this.isStarted()) {
            this.proxyServer.setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(connectTimeout, timeUnit));
        }
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout, TimeUnit timeUnit) {
        long timeout = TimeUnit.SECONDS.convert(idleConnectionTimeout, timeUnit);
        this.idleConnectionTimeoutSec = timeout == 0L && idleConnectionTimeout > 0 ? 1 : (int)timeout;
        if (this.isStarted()) {
            this.proxyServer.setIdleConnectionTimeout(this.idleConnectionTimeoutSec);
        }
    }

    @Override
    public void setRequestTimeout(int requestTimeout, TimeUnit timeUnit) {
        if (this.idleConnectionTimeoutSec == 0 || (long)this.idleConnectionTimeoutSec > TimeUnit.SECONDS.convert(requestTimeout, timeUnit)) {
            this.setIdleConnectionTimeout(requestTimeout, timeUnit);
        }
    }

    @Override
    public void rewriteUrl(String pattern, String replace) {
        this.rewriteRules.add(new RewriteRule(pattern, replace));
    }

    @Override
    public void rewriteUrls(Map<String, String> rewriteRules) {
        ArrayList<RewriteRule> newRules = new ArrayList<RewriteRule>(rewriteRules.size());
        for (Map.Entry<String, String> rewriteRule : rewriteRules.entrySet()) {
            RewriteRule newRule = new RewriteRule(rewriteRule.getKey(), rewriteRule.getValue());
            newRules.add(newRule);
        }
        this.rewriteRules = new CopyOnWriteArrayList(newRules);
    }

    @Override
    public void clearRewriteRules() {
        this.rewriteRules.clear();
    }

    @Override
    public void blacklistRequests(String pattern, int responseCode) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode));
    }

    @Override
    public void blacklistRequests(String pattern, int responseCode, String method) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode, method));
    }

    @Override
    public void setBlacklist(Collection<BlacklistEntry> blacklist) {
        this.blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>(blacklist);
    }

    @Override
    public Collection<BlacklistEntry> getBlacklist() {
        return Collections.unmodifiableCollection(this.blacklistEntries);
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.whitelist.get().isEnabled();
    }

    @Override
    public Collection<String> getWhitelistUrls() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pattern pattern : this.whitelist.get().getPatterns()) {
            builder.add((Object)pattern.pattern());
        }
        return builder.build();
    }

    @Override
    public int getWhitelistStatusCode() {
        return this.whitelist.get().getStatusCode();
    }

    @Override
    public void clearBlacklist() {
        this.blacklistEntries.clear();
    }

    @Override
    public void whitelistRequests(Collection<String> urlPatterns, int statusCode) {
        this.whitelist.set(new Whitelist(urlPatterns, statusCode));
    }

    @Override
    public void addWhitelistPattern(String urlPattern) {
        boolean whitelistUpdated = false;
        while (!whitelistUpdated) {
            Whitelist currentWhitelist = this.whitelist.get();
            if (!currentWhitelist.isEnabled()) {
                throw new IllegalStateException("Whitelist is disabled. Cannot add patterns to a disabled whitelist.");
            }
            int statusCode = currentWhitelist.getStatusCode();
            ArrayList<String> newPatterns = new ArrayList<String>(currentWhitelist.getPatterns().size() + 1);
            for (Pattern pattern : currentWhitelist.getPatterns()) {
                newPatterns.add(pattern.pattern());
            }
            newPatterns.add(urlPattern);
            Whitelist newWhitelist = new Whitelist(newPatterns, statusCode);
            whitelistUpdated = this.whitelist.compareAndSet(currentWhitelist, newWhitelist);
        }
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        if (patterns == null || patterns.length == 0) {
            this.enableEmptyWhitelist(responseCode);
        } else {
            this.whitelistRequests(Arrays.asList(patterns), responseCode);
        }
    }

    @Override
    public void enableEmptyWhitelist(int statusCode) {
        this.whitelist.set(new Whitelist(statusCode));
    }

    @Override
    public void disableWhitelist() {
        this.whitelist.set(Whitelist.WHITELIST_DISABLED);
    }

    @Override
    public void addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    @Override
    public void removeHeader(String name) {
        this.additionalHeaders.remove(name);
    }

    @Override
    public void removeAllHeaders() {
        this.additionalHeaders.clear();
    }

    @Override
    public Map<String, String> getAllHeaders() {
        return ImmutableMap.copyOf(this.additionalHeaders);
    }

    @Override
    public void setHostNameResolver(AdvancedHostResolver resolver) {
        this.delegatingResolver.setResolver(resolver);
    }

    @Override
    public AdvancedHostResolver getHostNameResolver() {
        return this.delegatingResolver.getResolver();
    }

    @Override
    public boolean waitForQuiescence(long quietPeriod, long timeout, TimeUnit timeUnit) {
        return this.activityMonitor.waitForQuiescence(quietPeriod, timeout, timeUnit);
    }

    @Override
    public void setChainedProxy(InetSocketAddress chainedProxyAddress) {
        this.upstreamProxyAddress = chainedProxyAddress;
    }

    @Override
    public InetSocketAddress getChainedProxy() {
        return this.upstreamProxyAddress;
    }

    public void setChainedProxyManager(ChainedProxyManager chainedProxyManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot configure chained proxy manager after proxy has started.");
        }
        this.chainedProxyManager = chainedProxyManager;
    }

    public void setThreadPoolConfiguration(ThreadPoolConfiguration threadPoolConfiguration) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot configure thread pool after proxy has started.");
        }
        this.threadPoolConfiguration = threadPoolConfiguration;
    }

    @Override
    public void addFirstHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(0, filterFactory);
    }

    @Override
    public void addLastHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(filterFactory);
    }

    @Override
    public void addResponseFilter(ResponseFilter filter) {
        this.addLastHttpFilterFactory((HttpFiltersSource)new ResponseFilterAdapter.FilterSource(filter));
    }

    @Override
    public void addRequestFilter(RequestFilter filter) {
        this.addFirstHttpFilterFactory((HttpFiltersSource)new RequestFilterAdapter.FilterSource(filter));
    }

    @Override
    public Map<String, String> getRewriteRules() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RewriteRule rewriteRule : this.rewriteRules) {
            builder.put((Object)rewriteRule.getPattern().pattern(), (Object)rewriteRule.getReplace());
        }
        return builder.build();
    }

    @Override
    public void removeRewriteRule(String urlPattern) {
        for (RewriteRule rewriteRule : this.rewriteRules) {
            if (!rewriteRule.getPattern().pattern().equals(urlPattern)) continue;
            this.rewriteRules.remove(rewriteRule);
        }
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public HarPage getCurrentHarPage() {
        return this.currentHarPage;
    }

    public void addHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(filterFactory);
    }

    public List<HttpFiltersSource> getFilterFactories() {
        return this.filterFactories;
    }

    @Override
    public void setMitmDisabled(boolean mitmDisabled) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot disable MITM after the proxy has been started");
        }
        this.mitmDisabled = mitmDisabled;
    }

    @Override
    public void setMitmManager(MitmManager mitmManager) {
        this.mitmManager = mitmManager;
    }

    @Override
    public void setTrustAllServers(boolean trustAllServers) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot disable upstream server verification after the proxy has been started");
        }
        if (trustAllServers) {
            this.trustSource = null;
        } else if (this.trustSource == null) {
            this.trustSource = TrustSource.defaultTrustSource();
        }
    }

    @Override
    public void setTrustSource(TrustSource trustSource) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot change TrustSource after proxy has been started");
        }
        this.trustSource = trustSource;
    }

    public boolean isMitmDisabled() {
        return this.mitmDisabled;
    }

    public void setUseEcc(boolean useEcc) {
        this.useEcc = useEcc;
    }

    protected void addBrowserMobFilters() {
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new ResolvedHostnameCacheFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new RegisterRequestFilter(originalRequest, ctx, BrowserMobProxyServer.this.activityMonitor);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpsOriginalHostCaptureFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new BlacklistFilter(originalRequest, ctx, BrowserMobProxyServer.this.getBlacklist());
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                Whitelist currentWhitelist = (Whitelist)BrowserMobProxyServer.this.whitelist.get();
                return new WhitelistFilter(originalRequest, ctx, BrowserMobProxyServer.this.isWhitelistEnabled(), currentWhitelist.getStatusCode(), currentWhitelist.getPatterns());
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new AutoBasicAuthFilter(originalRequest, ctx, BrowserMobProxyServer.this.basicAuthCredentials);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new RewriteUrlFilter(originalRequest, ctx, BrowserMobProxyServer.this.rewriteRules);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpsHostCaptureFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return new AddHeadersFilter(originalRequest, BrowserMobProxyServer.this.additionalHeaders);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return new LatencyFilter(originalRequest, BrowserMobProxyServer.this.latencyMs);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new UnregisterRequestFilter(originalRequest, ctx, BrowserMobProxyServer.this.activityMonitor);
            }
        });
    }

    private int getMaximumRequestBufferSize() {
        int maxBufferSize = 0;
        for (HttpFiltersSource source : this.filterFactories) {
            int requestBufferSize = source.getMaximumRequestBufferSizeInBytes();
            if (requestBufferSize <= maxBufferSize) continue;
            maxBufferSize = requestBufferSize;
        }
        return maxBufferSize;
    }

    private int getMaximumResponseBufferSize() {
        int maxBufferSize = 0;
        for (HttpFiltersSource source : this.filterFactories) {
            int requestBufferSize = source.getMaximumResponseBufferSizeInBytes();
            if (requestBufferSize <= maxBufferSize) continue;
            maxBufferSize = requestBufferSize;
        }
        return maxBufferSize;
    }

    protected void addHarCaptureFilter() {
        if (this.harCaptureFilterEnabled.compareAndSet(false, true)) {
            this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

                public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                    Har har = BrowserMobProxyServer.this.getHar();
                    if (har != null && !ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                        return new HarCaptureFilter(originalRequest, ctx, har, BrowserMobProxyServer.this.getCurrentHarPage() == null ? null : BrowserMobProxyServer.this.getCurrentHarPage().getId(), BrowserMobProxyServer.this.getHarCaptureTypes());
                    }
                    return null;
                }
            });
            this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

                public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                    Har har = BrowserMobProxyServer.this.getHar();
                    if (har != null && ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                        return new HttpConnectHarCaptureFilter(originalRequest, ctx, har, BrowserMobProxyServer.this.getCurrentHarPage() == null ? null : BrowserMobProxyServer.this.getCurrentHarPage().getId());
                    }
                    return null;
                }
            });
        }
    }
}

