/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyFilter
extends HttpFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(HttpFiltersAdapter.class);
    private final int latencyMs;

    public LatencyFilter(HttpRequest originalRequest, int latencyMs) {
        super(originalRequest);
        this.latencyMs = latencyMs;
    }

    public HttpObject proxyToClientResponse(HttpObject httpObject) {
        if (httpObject instanceof HttpResponse && this.latencyMs > 0) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.latencyMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while adding latency to response", (Throwable)e);
            }
        }
        return super.proxyToClientResponse(httpObject);
    }
}

