/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.dns;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;

public class ChainedHostResolver
implements AdvancedHostResolver {
    private final List<? extends AdvancedHostResolver> resolvers;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public ChainedHostResolver(Collection<? extends AdvancedHostResolver> resolvers) {
        this.resolvers = resolvers == null ? Collections.emptyList() : ImmutableList.copyOf(resolvers);
    }

    public Collection<? extends AdvancedHostResolver> getResolvers() {
        return ImmutableList.copyOf(this.resolvers);
    }

    @Override
    public void remapHosts(Map<String, String> hostRemappings) {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.remapHosts(hostRemappings);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remapHost(String originalHost, String remappedHost) {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.remapHost(originalHost, remappedHost);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeHostRemapping(String originalHost) {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.removeHostRemapping(originalHost);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clearHostRemappings() {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.clearHostRemappings();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Map<String, String> getHostRemappings() {
        this.readLock.lock();
        try {
            if (this.resolvers.isEmpty()) {
                Map<String, String> map = Collections.emptyMap();
                return map;
            }
            Map<String, String> map = this.resolvers.get(0).getHostRemappings();
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<String> getOriginalHostnames(String remappedHost) {
        this.readLock.lock();
        try {
            if (this.resolvers.isEmpty()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = this.resolvers.get(0).getOriginalHostnames(remappedHost);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clearDNSCache() {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.clearDNSCache();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void setPositiveDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.setPositiveDNSCacheTimeout(timeout, timeUnit);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void setNegativeDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        this.writeLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                advancedHostResolver.setNegativeDNSCacheTimeout(timeout, timeUnit);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Collection<InetAddress> resolve(String host) {
        this.readLock.lock();
        try {
            for (AdvancedHostResolver advancedHostResolver : this.resolvers) {
                Collection<InetAddress> results = advancedHostResolver.resolve(host);
                if (results.isEmpty()) continue;
                Collection<InetAddress> collection = results;
                return collection;
            }
            List<InetAddress> list = Collections.emptyList();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

