/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarCookie;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.proxy.BlacklistEntry;
import net.lightbody.bmp.proxy.Main;
import net.lightbody.bmp.proxy.Whitelist;
import net.lightbody.bmp.proxy.http.AllowAllHostnameVerifier;
import net.lightbody.bmp.proxy.http.BadURIException;
import net.lightbody.bmp.proxy.http.BrowserMobHostNameResolver;
import net.lightbody.bmp.proxy.http.BrowserMobHttpRequest;
import net.lightbody.bmp.proxy.http.BrowserMobHttpResponse;
import net.lightbody.bmp.proxy.http.HttpClientInterrupter;
import net.lightbody.bmp.proxy.http.HttpDeleteWithBody;
import net.lightbody.bmp.proxy.http.RequestInfo;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import net.lightbody.bmp.proxy.http.SimulatedSocketFactory;
import net.lightbody.bmp.proxy.http.TrustingSSLSocketFactory;
import net.lightbody.bmp.proxy.http.WildcardMatchingCredentialsProvider;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.util.Base64;
import net.lightbody.bmp.proxy.util.CappedByteArrayOutputStream;
import net.lightbody.bmp.proxy.util.ClonedOutputStream;
import net.lightbody.bmp.proxy.util.IOUtils;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.service.UADetectorServiceFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.java_bandwidthlimiter.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Cache;

public class BrowserMobHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserMobHttpClient.class);
    private static volatile UserAgentStringParser parser;
    private static final int BUFFER = 4096;
    private volatile Har har;
    private volatile String harPageRef;
    private volatile boolean captureHeaders;
    private volatile boolean captureContent;
    private volatile boolean captureBinaryContent = true;
    private final SimulatedSocketFactory socketFactory;
    private final TrustingSSLSocketFactory sslSocketFactory;
    private final PoolingHttpClientConnectionManager httpClientConnMgr;
    private final RequestConfig.Builder requestConfigBuilder;
    private final HttpClientBuilder httpClientBuilder;
    private volatile CloseableHttpClient httpClient;
    private final BasicCookieStore cookieStore = new BasicCookieStore();
    private final Collection<BlacklistEntry> blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>();
    private volatile Whitelist whitelist = Whitelist.WHITELIST_DISABLED;
    private final List<RewriteRule> rewriteRules = new CopyOnWriteArrayList<RewriteRule>();
    private final List<RequestInterceptor> requestInterceptors = new CopyOnWriteArrayList<RequestInterceptor>();
    private final List<ResponseInterceptor> responseInterceptors = new CopyOnWriteArrayList<ResponseInterceptor>();
    private final Map<String, String> additionalHeaders = new ConcurrentHashMap<String, String>();
    private volatile int requestTimeout = -1;
    private final AtomicBoolean allowNewRequests = new AtomicBoolean(true);
    private final BrowserMobHostNameResolver hostNameResolver;
    private boolean decompress = true;
    private final Set<ActiveRequest> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private WildcardMatchingCredentialsProvider credsProvider;
    private volatile boolean shutdown = false;
    private AuthType authType;
    private boolean followRedirects = true;
    private static final int MAX_REDIRECT = 10;
    private final AtomicInteger requestCounter;
    private static final Object PARSER_INIT_LOCK;

    public BrowserMobHttpClient(StreamManager streamManager, AtomicInteger requestCounter) {
        this.requestCounter = requestCounter;
        this.hostNameResolver = new BrowserMobHostNameResolver(new Cache(255));
        this.socketFactory = new SimulatedSocketFactory(streamManager);
        this.sslSocketFactory = new TrustingSSLSocketFactory(new AllowAllHostnameVerifier(), streamManager);
        this.requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(60000).setConnectTimeout(2000).setSocketTimeout(60000);
        Registry registry = RegistryBuilder.create().register("http", (Object)this.socketFactory).register("https", (Object)this.sslSocketFactory).build();
        this.httpClientConnMgr = new PoolingHttpClientConnectionManager(registry, this.hostNameResolver){

            public ConnectionRequest requestConnection(HttpRoute route, Object state) {
                final ConnectionRequest wrapped = super.requestConnection(route, state);
                return new ConnectionRequest(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public HttpClientConnection get(long timeout, TimeUnit tunit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
                        Date start = new Date();
                        try {
                            HttpClientConnection httpClientConnection = wrapped.get(timeout, tunit);
                            return httpClientConnection;
                        }
                        finally {
                            RequestInfo.get().blocked(start, new Date());
                        }
                    }

                    public boolean cancel() {
                        return wrapped.cancel();
                    }
                };
            }
        };
        this.httpClientConnMgr.setMaxTotal(600);
        this.httpClientConnMgr.setDefaultMaxPerRoute(300);
        this.credsProvider = new WildcardMatchingCredentialsProvider();
        this.httpClientBuilder = this.getDefaultHttpClientBuilder(streamManager);
        this.httpClient = this.httpClientBuilder.build();
        HttpClientInterrupter.watch(this);
    }

    private HttpClientBuilder getDefaultHttpClientBuilder(final StreamManager streamManager) {
        assert (this.requestConfigBuilder != null);
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.httpClientConnMgr).setRequestExecutor(new HttpRequestExecutor(){

            protected HttpResponse doSendRequest(org.apache.http.HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                Date start = new Date();
                HttpResponse response = super.doSendRequest(request, conn, context);
                RequestInfo.get().send(start, new Date());
                return response;
            }

            protected HttpResponse doReceiveResponse(org.apache.http.HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
                long realLatency;
                Date start = new Date();
                HttpResponse response = super.doReceiveResponse(request, conn, context);
                long responseHeadersSize = response.getStatusLine().toString().length() + 4;
                for (Header header : response.getAllHeaders()) {
                    responseHeadersSize += (long)(header.toString().length() + 2);
                }
                HarEntry entry = RequestInfo.get().getEntry();
                if (entry != null) {
                    entry.getResponse().setHeadersSize(responseHeadersSize);
                }
                if (streamManager.getLatency() > 0L && RequestInfo.get().getLatency() != null && (realLatency = RequestInfo.get().getLatency().longValue()) < streamManager.getLatency()) {
                    try {
                        Thread.sleep(streamManager.getLatency() - realLatency);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                RequestInfo.get().wait(start, new Date());
                return response;
            }
        }).setDefaultRequestConfig(this.requestConfigBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider).setDefaultCookieStore((CookieStore)this.cookieStore).addInterceptorLast((HttpRequestInterceptor)new PreemptiveAuth()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).setHttpProcessor(HttpProcessorBuilder.create().build()).disableRedirectHandling();
    }

    public void setRetryCount(int count) {
        this.httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(count, false));
        this.updateHttpClient();
    }

    public void remapHost(String source, String target) {
        this.hostNameResolver.remap(source, target);
    }

    @Deprecated
    public void addRequestInterceptor(HttpRequestInterceptor i) {
        this.httpClientBuilder.addInterceptorLast(i);
        this.updateHttpClient();
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
    }

    @Deprecated
    public void addResponseInterceptor(HttpResponseInterceptor i) {
        this.httpClientBuilder.addInterceptorLast(i);
        this.updateHttpClient();
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.responseInterceptors.add(interceptor);
    }

    public void createCookie(String name, String value, String domain) {
        this.createCookie(name, value, domain, null);
    }

    public void createCookie(String name, String value, String domain, String path) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        if (path != null) {
            cookie.setPath(path);
        }
        this.cookieStore.addCookie((Cookie)cookie);
    }

    public void clearCookies() {
        this.cookieStore.clear();
    }

    public Cookie getCookie(String name) {
        return this.getCookie(name, null, null);
    }

    public Cookie getCookie(String name, String domain) {
        return this.getCookie(name, domain, null);
    }

    public Cookie getCookie(String name, String domain, String path) {
        for (Cookie cookie : this.cookieStore.getCookies()) {
            if (!cookie.getName().equals(name) || domain != null && !domain.equals(cookie.getDomain()) || path != null && !path.equals(cookie.getPath())) continue;
            return cookie;
        }
        return null;
    }

    public BrowserMobHttpRequest newPost(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpPost(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "POST", e);
        }
    }

    public BrowserMobHttpRequest newGet(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpGet(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "GET", e);
        }
    }

    public BrowserMobHttpRequest newPatch(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpPatch(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "PATCH", e);
        }
    }

    public BrowserMobHttpRequest newPut(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpPut(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "PUT", e);
        }
    }

    public BrowserMobHttpRequest newDelete(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpDeleteWithBody(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "DELETE", e);
        }
    }

    public BrowserMobHttpRequest newOptions(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpOptions(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "OPTIONS", e);
        }
    }

    public BrowserMobHttpRequest newHead(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpHead(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "HEAD", e);
        }
    }

    private URI makeUri(String url) throws URISyntaxException {
        url = url.replace(" ", "%20");
        url = url.replace(">", "%3C");
        url = url.replace("<", "%3E");
        url = url.replace("#", "%23");
        url = url.replace("{", "%7B");
        url = url.replace("}", "%7D");
        url = url.replace("|", "%7C");
        url = url.replace("\\", "%5C");
        url = url.replace("^", "%5E");
        url = url.replace("~", "%7E");
        url = url.replace("[", "%5B");
        url = url.replace("]", "%5D");
        url = url.replace("`", "%60");
        URI uri = new URI(url = url.replace("\"", "%22"));
        if (uri.getPort() == 80 && "http".equals(uri.getScheme()) || uri.getPort() == 443 && "https".equals(uri.getScheme())) {
            StringBuilder sb = new StringBuilder(uri.getScheme()).append("://");
            if (uri.getRawUserInfo() != null) {
                sb.append(uri.getRawUserInfo()).append("@");
            }
            sb.append(uri.getHost());
            if (uri.getRawPath() != null) {
                sb.append(uri.getRawPath());
            }
            if (uri.getRawQuery() != null) {
                sb.append("?").append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                sb.append("#").append(uri.getRawFragment());
            }
            uri = new URI(sb.toString());
        }
        return uri;
    }

    private BadURIException reportBadURI(String url, String method, URISyntaxException cause) {
        if (this.har != null && this.harPageRef != null) {
            HarEntry entry = new HarEntry(this.harPageRef);
            entry.setStartedDateTime(new Date());
            entry.setRequest(new HarRequest(method, url, "HTTP/1.1"));
            entry.setResponse(new HarResponse(-998, "Bad URI", "HTTP/1.1"));
            this.har.getLog().addEntry(entry);
        }
        throw new BadURIException("Bad URI requested: " + url, cause);
    }

    public void checkTimeout() {
        for (ActiveRequest activeRequest : this.activeRequests) {
            activeRequest.checkTimeout();
        }
        this.httpClientConnMgr.closeExpiredConnections();
        this.httpClientConnMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserMobHttpResponse execute(BrowserMobHttpRequest req) {
        if (!this.allowNewRequests.get()) {
            throw new RuntimeException("No more requests allowed");
        }
        try {
            this.requestCounter.incrementAndGet();
            for (RequestInterceptor interceptor : this.requestInterceptors) {
                interceptor.process(req, this.har);
            }
            BrowserMobHttpResponse response = this.execute(req, 1);
            for (ResponseInterceptor interceptor : this.responseInterceptors) {
                interceptor.process(response, this.har);
            }
            BrowserMobHttpResponse browserMobHttpResponse = response;
            return browserMobHttpResponse;
        }
        finally {
            this.requestCounter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private BrowserMobHttpResponse execute(BrowserMobHttpRequest req, int depth) {
        if (depth >= 10) {
            throw new IllegalStateException("Max number of redirects (10) reached");
        }
        callback = req.getRequestCallback();
        method = req.getMethod();
        url = method.getURI().toString();
        if (this.har != null && this.har.getLog().getBrowser() == null && (uaHeaders = method.getHeaders("User-Agent")) != null && uaHeaders.length > 0) {
            userAgent = uaHeaders[0].getValue();
            try {
                uai = BrowserMobHttpClient.getUserAgentStringParser().parse(userAgent);
                browser = uai.getName();
                version = uai.getVersionNumber().toVersionString();
                this.har.getLog().setBrowser(new HarNameVersion(browser, version));
            }
            catch (RuntimeException e) {
                BrowserMobHttpClient.LOG.warn("Failed to parse user agent string", (Throwable)e);
            }
        }
        rewrote = false;
        newUrl = url;
        for (RewriteRule rule : this.rewriteRules) {
            matcher = RewriteRule.access$000(rule).matcher(newUrl);
            newUrl = matcher.replaceAll(RewriteRule.access$100(rule));
            rewrote = true;
        }
        if (rewrote) {
            try {
                method.setURI(new URI(newUrl));
                url = newUrl;
            }
            catch (URISyntaxException e) {
                BrowserMobHttpClient.LOG.warn("Could not rewrite url to " + newUrl, (Throwable)e);
            }
        }
        mockResponseCode = -1;
        currentWhitelist = this.whitelist;
        if (currentWhitelist.isEnabled()) {
            found = false;
            for (Pattern pattern : currentWhitelist.getPatterns()) {
                if (!pattern.matcher(url).matches()) continue;
                found = true;
                break;
            }
            if (!found) {
                mockResponseCode = currentWhitelist.getResponseCode();
            }
        }
        for (BlacklistEntry blacklistEntry : this.blacklistEntries) {
            if (!blacklistEntry.matches(url, method.getMethod())) continue;
            mockResponseCode = blacklistEntry.getResponseCode();
            break;
        }
        if (!this.additionalHeaders.isEmpty()) {
            for (Map.Entry entry : this.additionalHeaders.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                method.removeHeaders(key);
                method.addHeader(key, value);
            }
        }
        charSet = "UTF-8";
        is = null;
        statusCode = -998;
        bytes = 0L;
        gzipping = false;
        deflating = false;
        os = req.getOutputStream();
        if (os == null) {
            os = new CappedByteArrayOutputStream(0x100000);
        }
        entry = new HarEntry(this.harPageRef);
        entry.setStartedDateTime(new Date());
        RequestInfo.clear(url, entry);
        entry.setRequest(new HarRequest(method.getMethod(), url, method.getProtocolVersion().toString()));
        entry.setResponse(new HarResponse(-999, "NO RESPONSE", method.getProtocolVersion().toString()));
        if (this.har != null && this.harPageRef != null) {
            this.har.getLog().addEntry(entry);
        }
        if ((query = method.getURI().getRawQuery()) != null) {
            params = new MultiMap();
            UrlEncoded.decodeTo((String)query, (MultiMap)params, (String)"UTF-8");
            for (String k : params.keySet()) {
                for (E v : params.getValues((Object)k)) {
                    entry.getRequest().getQueryString().add(new HarNameValuePair(k, (String)v));
                }
            }
        }
        errorMessage = null;
        response = null;
        ctx = new BasicHttpContext();
        activeRequest = new ActiveRequest(method, entry.getStartedDateTime());
        this.activeRequests.add(activeRequest);
        if (this.authType != AuthType.NTLM && this.authType == AuthType.BASIC) {
            ctx.setAttribute("preemptive-auth", (Object)new BasicScheme());
        }
        statusLine = null;
        try {
            if (method.getHeaders("User-Agent").length == 0) {
                method.addHeader("User-Agent", "bmp.lightbody.net/" + Main.getVersion());
            }
            if (mockResponseCode != -1) {
                statusCode = mockResponseCode;
                callback.handleHeaders(new Header[]{new Header(){

                    public String getName() {
                        return "Content-Type";
                    }

                    public String getValue() {
                        return "text/plain";
                    }

                    public HeaderElement[] getElements() throws ParseException {
                        return new HeaderElement[0];
                    }
                }});
                version = null;
                reqDotVersion = req.getProxyRequest().getDotVersion();
                if (reqDotVersion == -1) {
                    version = new HttpVersion(0, 9);
                } else if (reqDotVersion == 0) {
                    version = new HttpVersion(1, 0);
                } else if (reqDotVersion == 1) {
                    version = new HttpVersion(1, 1);
                }
                callback.handleStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)version, statusCode, "Status set by browsermob-proxy"));
            } else {
                response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)ctx);
                statusLine = response.getStatusLine();
                statusCode = statusLine.getStatusCode();
                if (callback != null) {
                    callback.handleStatusLine(statusLine);
                    callback.handleHeaders(response.getAllHeaders());
                }
                if (response.getEntity() != null) {
                    is = response.getEntity().getContent();
                }
                if (is != null) {
                    contentEncodingHeader = response.getFirstHeader("Content-Encoding");
                    if (contentEncodingHeader != null) {
                        if ("gzip".equalsIgnoreCase(contentEncodingHeader.getValue())) {
                            gzipping = true;
                        } else if ("deflate".equalsIgnoreCase(contentEncodingHeader.getValue())) {
                            deflating = true;
                        }
                    }
                    if (this.decompress && response.getEntity().getContentLength() != 0L) {
                        if (gzipping) {
                            is = new GZIPInputStream(is);
                        } else if (deflating) {
                            is = new InflaterInputStream(is, new Inflater(true));
                        }
                    }
                    if (this.captureContent) {
                        os = new ClonedOutputStream(os);
                    }
                    bytes = BrowserMobHttpClient.copyWithStats(is, os);
                }
            }
        }
        catch (IOException e) {
            errorMessage = e.toString();
            if (callback != null) {
                callback.reportError(e);
            }
            if (!this.shutdown) {
                if (BrowserMobHttpClient.LOG.isDebugEnabled()) {
                    BrowserMobHttpClient.LOG.info(String.format("%s when requesting %s", new Object[]{errorMessage, url}), (Throwable)e);
                } else {
                    BrowserMobHttpClient.LOG.info(String.format("%s when requesting %s", new Object[]{errorMessage, url}));
                }
            }
        }
        finally {
            this.activeRequests.remove(activeRequest);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    BrowserMobHttpClient.LOG.info("Error closing input stream", (Throwable)e);
                }
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    BrowserMobHttpClient.LOG.info("Error closing response stream", (Throwable)e);
                }
            }
        }
        RequestInfo.get().finish();
        entry.setStartedDateTime(RequestInfo.get().getStart());
        entry.setTimings(RequestInfo.get().getTimings());
        entry.setServerIPAddress(RequestInfo.get().getResolvedAddress());
        entry.getResponse().setBodySize(bytes);
        entry.getResponse().getContent().setSize(bytes);
        entry.getResponse().setStatus(statusCode);
        if (response != null) {
            entry.getResponse().setHttpVersion(response.getProtocolVersion().toString());
        }
        if (statusLine != null) {
            entry.getResponse().setStatusText(statusLine.getReasonPhrase());
        }
        urlEncoded = false;
        if (this.captureHeaders || this.captureContent) {
            for (Header header : method.getAllHeaders()) {
                if (header.getValue() != null && header.getValue().startsWith("application/x-www-form-urlencoded")) {
                    urlEncoded = true;
                }
                entry.getRequest().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
            }
            if (response != null) {
                for (Header header : response.getAllHeaders()) {
                    entry.getResponse().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
                }
            }
        }
        requestHeadersSize = method.getRequestLine().toString().length() + 4;
        requestBodySize = 0L;
        for (Header header : method.getAllHeaders()) {
            requestHeadersSize += (long)(header.toString().length() + 2);
            if (!header.getName().equals("Content-Length")) continue;
            requestBodySize += (long)Integer.valueOf(header.getValue()).intValue();
        }
        entry.getRequest().setHeadersSize(requestHeadersSize);
        entry.getRequest().setBodySize(requestBodySize);
        if (this.captureContent && method instanceof HttpEntityEnclosingRequestBase && req.getCopy() != null) {
            enclosingReq = (HttpEntityEnclosingRequestBase)method;
            entity = enclosingReq.getEntity();
            data = new HarPostData();
            data.setMimeType(req.getMethod().getFirstHeader("Content-Type").getValue());
            entry.getRequest().setPostData(data);
            if (urlEncoded || URLEncodedUtils.isEncoded((HttpEntity)entity)) {
                try {
                    content = req.getCopy().toString("UTF-8");
                    if (content == null || content.length() <= 0) ** GOTO lbl220
                    result = new ArrayList<E>();
                    URLEncodedUtils.parse(result, (Scanner)new Scanner(content), null);
                    params = new ArrayList<HarPostDataParam>(result.size());
                    data.setParams(params);
                    for (NameValuePair pair : result) {
                        params.add(new HarPostDataParam(pair.getName(), pair.getValue()));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    BrowserMobHttpClient.LOG.info("Unexpected problem when parsing input copy", (Throwable)e);
                }
                catch (RuntimeException e) {
                    BrowserMobHttpClient.LOG.info("Unexpected problem when parsing input copy", (Throwable)e);
                }
            } else {
                try {
                    postBody = req.getCopy().toString("UTF-8");
                    data.setText(postBody);
                }
                catch (UnsupportedEncodingException e) {
                    BrowserMobHttpClient.LOG.info("Unexpected problem when parsing post body", (Throwable)e);
                }
            }
        }
lbl220:
        // 9 sources

        for (javax.servlet.http.Cookie cookie : cookies = req.getProxyRequest().getCookies()) {
            hc = new HarCookie();
            hc.setName(cookie.getName());
            hc.setValue(cookie.getValue());
            entry.getRequest().getCookies().add(hc);
        }
        contentType = null;
        if (response != null && (contentTypeHdr = response.getFirstHeader("Content-Type")) != null) {
            contentType = contentTypeHdr.getValue();
            entry.getResponse().getContent().setMimeType(contentType);
            if (this.captureContent && os != null && os instanceof ClonedOutputStream) {
                copy = ((ClonedOutputStream)os).getOutput();
                if (entry.getResponse().getBodySize() != 0L && (gzipping || deflating)) {
                    try {
                        temp /* !! */  = null;
                        if (gzipping) {
                            temp /* !! */  = new GZIPInputStream(new ByteArrayInputStream(copy.toByteArray()));
                        } else if (deflating) {
                            temp /* !! */  = new InflaterInputStream(new ByteArrayInputStream(copy.toByteArray()), new Inflater(true));
                        }
                        copy = new ByteArrayOutputStream();
                        IOUtils.copy(temp /* !! */ , copy);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error when decompressing input stream", e);
                    }
                }
                if (this.hasTextualContent(contentType)) {
                    this.setTextOfEntry(entry, copy, contentType);
                } else if (this.captureBinaryContent) {
                    this.setBinaryContentOfEntry(entry, copy);
                }
            }
            if ((nvp = contentTypeHdr.getElements()[0].getParameterByName("charset")) != null) {
                charSet = nvp.getValue();
            }
        }
        if (contentType != null) {
            entry.getResponse().getContent().setMimeType(contentType);
        }
        isRedirect = false;
        location = null;
        if (response != null && statusCode >= 300 && statusCode < 400 && statusCode != 304) {
            isRedirect = true;
            locationHeader = response.getLastHeader("location");
            if (locationHeader != null) {
                location = locationHeader.getValue();
            } else if (this.followRedirects) {
                throw new RuntimeException("Invalid redirect - missing location header");
            }
        }
        expectedStatusCode = req.getExpectedStatusCode();
        if (mockResponseCode == -1 && expectedStatusCode > -1) {
            if (this.followRedirects) {
                throw new RuntimeException("Response validation cannot be used while following redirects");
            }
            if (expectedStatusCode != statusCode) {
                if (isRedirect) {
                    throw new RuntimeException("Expected status code of " + expectedStatusCode + " but saw " + statusCode + " redirecting to: " + location);
                }
                throw new RuntimeException("Expected status code of " + expectedStatusCode + " but saw " + statusCode);
            }
        }
        if (isRedirect && req.getExpectedLocation() != null) {
            if (this.followRedirects) {
                throw new RuntimeException("Response validation cannot be used while following redirects");
            }
            if (location.compareTo(req.getExpectedLocation()) != 0) {
                throw new RuntimeException("Expected a redirect to  " + req.getExpectedLocation() + " but saw " + location);
            }
        }
        if (isRedirect && this.followRedirects) {
            try {
                redirectUri = new URI(location);
                newUri = method.getURI().resolve(redirectUri);
                method.setURI(newUri);
                return this.execute(req, ++depth);
            }
            catch (URISyntaxException e) {
                BrowserMobHttpClient.LOG.warn("Could not parse URL", (Throwable)e);
            }
        }
        return new BrowserMobHttpResponse(entry, method, (HttpResponse)response, errorMessage, contentType, charSet);
    }

    private boolean hasTextualContent(String contentType) {
        return contentType != null && contentType.startsWith("text/") || contentType.startsWith("application/x-javascript") || contentType.startsWith("application/javascript") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/xhtml+xml");
    }

    private void setBinaryContentOfEntry(HarEntry entry, ByteArrayOutputStream copy) {
        entry.getResponse().getContent().setText(Base64.byteArrayToBase64(copy.toByteArray()));
        entry.getResponse().getContent().setEncoding("base64");
    }

    private void setTextOfEntry(HarEntry entry, ByteArrayOutputStream copy, String contentType) {
        ContentType contentTypeCharset = ContentType.parse((String)contentType);
        Charset charset = contentTypeCharset.getCharset();
        if (charset != null) {
            entry.getResponse().getContent().setText(new String(copy.toByteArray(), charset));
        } else {
            entry.getResponse().getContent().setText(new String(copy.toByteArray()));
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.abortActiveRequests();
        this.rewriteRules.clear();
        this.blacklistEntries.clear();
        this.credsProvider.clear();
        this.httpClientConnMgr.shutdown();
        HttpClientInterrupter.release(this);
    }

    public void abortActiveRequests() {
        this.allowNewRequests.set(false);
        for (ActiveRequest activeRequest : this.activeRequests) {
            activeRequest.abort();
        }
        this.activeRequests.clear();
    }

    public void setHar(Har har) {
        this.har = har;
        BrowserMobHttpClient.getUserAgentStringParser();
    }

    public void setHarPageRef(String harPageRef) {
        this.harPageRef = harPageRef;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setSocketOperationTimeout(int readTimeout) {
        this.requestConfigBuilder.setSocketTimeout(readTimeout);
        this.httpClientBuilder.setDefaultRequestConfig(this.requestConfigBuilder.build());
        this.updateHttpClient();
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectTimeout(connectionTimeout);
        this.httpClientBuilder.setDefaultRequestConfig(this.requestConfigBuilder.build());
        this.updateHttpClient();
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.authType = AuthType.BASIC;
        this.credsProvider.setCredentials(new AuthScope(domain, -1), (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public void autoNTLMAuthorization(String domain, String username, String password) {
        this.authType = AuthType.NTLM;
        this.credsProvider.setCredentials(new AuthScope(domain, -1), (Credentials)new NTCredentials(username, password, "workstation", domain));
    }

    public void rewriteUrl(String match, String replace) {
        this.rewriteRules.add(new RewriteRule(match, replace));
    }

    public void clearRewriteRules() {
        this.rewriteRules.clear();
    }

    @Deprecated
    public void blacklistRequest(String pattern, int responseCode, String method) {
        this.blacklistRequests(pattern, responseCode, method);
    }

    public void blacklistRequests(String pattern, int responseCode, String method) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode, method));
    }

    @Deprecated
    public List<BlacklistEntry> getBlacklistedRequests() {
        ArrayList<BlacklistEntry> blacklist = new ArrayList<BlacklistEntry>(this.blacklistEntries.size());
        blacklist.addAll(this.blacklistEntries);
        return blacklist;
    }

    public Collection<BlacklistEntry> getBlacklistedUrls() {
        return this.blacklistEntries;
    }

    public void clearBlacklist() {
        this.blacklistEntries.clear();
    }

    public boolean isWhitelistEnabled() {
        return this.whitelist.isEnabled();
    }

    @Deprecated
    public List<Pattern> getWhitelistRequests() {
        ArrayList<Pattern> whitelistPatterns = new ArrayList<Pattern>(this.whitelist.getPatterns().size());
        whitelistPatterns.addAll(this.whitelist.getPatterns());
        return Collections.unmodifiableList(whitelistPatterns);
    }

    public Collection<Pattern> getWhitelistUrls() {
        return this.whitelist.getPatterns();
    }

    public int getWhitelistResponseCode() {
        return this.whitelist.getResponseCode();
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        this.whitelist = patterns == null || patterns.length == 0 ? new Whitelist(responseCode) : new Whitelist(patterns, responseCode);
    }

    public void clearWhitelist() {
        this.whitelist = Whitelist.WHITELIST_DISABLED;
    }

    public void addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void prepareForBrowser() {
        this.cookieStore.clear();
        CookieSpecProvider easySpecProvider = new CookieSpecProvider(){

            public CookieSpec create(HttpContext context) {
                return new BrowserCompatSpec(){

                    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                    }
                };
            }
        };
        Registry r = RegistryBuilder.create().register("best-match", (Object)new BestMatchSpecFactory()).register("compatibility", (Object)new BrowserCompatSpecFactory()).register("easy", (Object)easySpecProvider).build();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("easy").build();
        this.httpClientBuilder.setDefaultCookieSpecRegistry((Lookup)r).setDefaultRequestConfig(requestConfig);
        this.updateHttpClient();
        this.decompress = false;
        this.setFollowRedirects(false);
    }

    private void updateHttpClient() {
        this.httpClient = this.httpClientBuilder.build();
    }

    public String remappedHost(String host) {
        return this.hostNameResolver.remapping(host);
    }

    public List<String> originalHosts(String host) {
        return this.hostNameResolver.original(host);
    }

    public Har getHar() {
        return this.har;
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.captureHeaders = captureHeaders;
    }

    public void setCaptureContent(boolean captureContent) {
        this.captureContent = captureContent;
    }

    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        this.captureBinaryContent = captureBinaryContent;
    }

    public void setHttpProxy(String httpProxy) {
        String host = httpProxy.split(":")[0];
        Integer port = Integer.parseInt(httpProxy.split(":")[1]);
        HttpHost proxy = new HttpHost(host, port.intValue());
        this.httpClientBuilder.setProxy(proxy);
        this.updateHttpClient();
    }

    public void clearDNSCache() {
        this.hostNameResolver.clearCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.hostNameResolver.setCacheTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyWithStats(InputStream is, OutputStream os) throws IOException {
        long bytesCopied = 0L;
        byte[] buffer = new byte[4096];
        try {
            int length;
            int firstByte = is.read();
            if (firstByte == -1) {
                long l = 0L;
                return l;
            }
            os.write(firstByte);
            ++bytesCopied;
            do {
                if ((length = is.read(buffer, 0, 4096)) == -1) continue;
                bytesCopied += (long)length;
                os.write(buffer, 0, length);
                os.flush();
            } while (length != -1);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            try {
                os.close();
            }
            catch (IOException e) {}
        }
        return bytesCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAgentStringParser getUserAgentStringParser() {
        if (parser == null) {
            Object object = PARSER_INIT_LOCK;
            synchronized (object) {
                if (parser == null) {
                    parser = UADetectorServiceFactory.getResourceModuleParser();
                }
            }
        }
        return parser;
    }

    static {
        PARSER_INIT_LOCK = new Object();
    }

    private static enum AuthType {
        NONE,
        BASIC,
        NTLM;

    }

    private class RewriteRule {
        private final Pattern match;
        private final String replace;

        private RewriteRule(String match, String replace) {
            this.match = Pattern.compile(match);
            this.replace = replace;
        }

        static /* synthetic */ Pattern access$000(RewriteRule x0) {
            return x0.match;
        }

        static /* synthetic */ String access$100(RewriteRule x0) {
            return x0.replace;
        }
    }

    class ActiveRequest {
        private final HttpRequestBase request;
        private final Date start;
        private final AtomicBoolean aborting = new AtomicBoolean(false);

        ActiveRequest(HttpRequestBase request, Date start) {
            this.request = request;
            this.start = start;
        }

        boolean checkTimeout() {
            boolean okayToAbort;
            if (this.aborting.get()) {
                return false;
            }
            if (BrowserMobHttpClient.this.requestTimeout != -1 && this.request != null && this.start != null && new Date(System.currentTimeMillis() - (long)BrowserMobHttpClient.this.requestTimeout).after(this.start) && (okayToAbort = this.aborting.compareAndSet(false, true))) {
                LOG.info("Aborting request to {} after it failed to complete in {} ms", (Object)this.request.getURI().toString(), (Object)BrowserMobHttpClient.this.requestTimeout);
                this.abort();
                return true;
            }
            return false;
        }

        public void abort() {
            this.request.abort();
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(org.apache.http.HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                Credentials creds;
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null && (creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                    authState.update(authScheme, creds);
                }
            }
        }
    }
}

