/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.handler;

import java.io.IOException;
import net.lightbody.bmp.proxy.jetty.http.BasicAuthenticator;
import net.lightbody.bmp.proxy.jetty.http.ClientCertAuthenticator;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.handler.AbstractHttpHandler;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import org.apache.commons.logging.Log;

public class SecurityHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(SecurityHandler.class);
    private String _authMethod = "BASIC";

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(method)) {
            throw new IllegalStateException("Handler started");
        }
        this._authMethod = method;
    }

    @Override
    public void start() throws Exception {
        if (this.getHttpContext().getAuthenticator() == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new BasicAuthenticator());
            } else if ("CLIENT_CERT".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new ClientCertAuthenticator());
            } else {
                log.warn((Object)("Unknown Authentication method:" + this._authMethod));
            }
        }
        super.start();
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        this.getHttpContext().checkSecurityConstraints(pathInContext, request, response);
    }
}

