/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyConnectionLogger;
import org.littleshoot.proxy.impl.ProxyToServerConnection;

class ConnectionFlow {
    private Queue<ConnectionFlowStep> steps = new ConcurrentLinkedQueue<ConnectionFlowStep>();
    private final ClientToProxyConnection clientConnection;
    private final ProxyToServerConnection serverConnection;
    private volatile ConnectionFlowStep currentStep;
    private volatile boolean suppressInitialRequest = false;
    private final Object connectLock;

    ConnectionFlow(ClientToProxyConnection clientConnection, ProxyToServerConnection serverConnection, Object connectLock) {
        this.clientConnection = clientConnection;
        this.serverConnection = serverConnection;
        this.connectLock = connectLock;
    }

    ConnectionFlow then(ConnectionFlowStep step) {
        this.steps.add(step);
        return this;
    }

    void read(Object msg) {
        if (this.currentStep != null) {
            this.currentStep.read(this, msg);
        }
    }

    void start() {
        this.clientConnection.serverConnectionFlowStarted(this.serverConnection);
        this.advance();
    }

    void advance() {
        this.currentStep = this.steps.poll();
        if (this.currentStep == null) {
            this.succeed();
        } else {
            this.processCurrentStep();
        }
    }

    private void processCurrentStep() {
        ProxyConnection connection = this.currentStep.getConnection();
        final ProxyConnectionLogger LOG = connection.getLOG();
        LOG.debug("Processing connection flow step: {}", this.currentStep);
        connection.become(this.currentStep.getState());
        boolean bl = this.suppressInitialRequest = this.suppressInitialRequest || this.currentStep.shouldSuppressInitialRequest();
        if (this.currentStep.shouldExecuteOnEventLoop()) {
            connection.ctx.executor().submit(new Runnable(){

                @Override
                public void run() {
                    ConnectionFlow.this.doProcessCurrentStep(LOG);
                }
            });
        } else {
            this.doProcessCurrentStep(LOG);
        }
    }

    private void doProcessCurrentStep(final ProxyConnectionLogger LOG) {
        this.currentStep.execute().addListener(new GenericFutureListener<Future<?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<?> future) throws Exception {
                Object object = ConnectionFlow.this.connectLock;
                synchronized (object) {
                    if (future.isSuccess()) {
                        LOG.debug("ConnectionFlowStep succeeded", new Object[0]);
                        ConnectionFlow.this.currentStep.onSuccess(ConnectionFlow.this);
                    } else {
                        LOG.debug("ConnectionFlowStep failed", future.cause());
                        ConnectionFlow.this.fail(future.cause());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void succeed() {
        Object object = this.connectLock;
        synchronized (object) {
            this.serverConnection.getLOG().debug("Connection flow completed successfully: {}", this.currentStep);
            this.serverConnection.connectionSucceeded(!this.suppressInitialRequest);
            this.notifyThreadsWaitingForConnection();
        }
    }

    void fail(final Throwable cause) {
        final ConnectionState lastStateBeforeFailure = this.serverConnection.getCurrentState();
        this.serverConnection.disconnect().addListener(new GenericFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future future) throws Exception {
                Object object = ConnectionFlow.this.connectLock;
                synchronized (object) {
                    if (!ConnectionFlow.this.clientConnection.serverConnectionFailed(ConnectionFlow.this.serverConnection, lastStateBeforeFailure, cause)) {
                        ConnectionFlow.this.serverConnection.become(ConnectionState.DISCONNECTED);
                        ConnectionFlow.this.notifyThreadsWaitingForConnection();
                    }
                }
            }
        });
    }

    void fail() {
        this.fail(null);
    }

    private void notifyThreadsWaitingForConnection() {
        this.connectLock.notifyAll();
    }
}

